% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bound_prediction.R
\name{bound_prediction}
\alias{bound_prediction}
\title{Truncate a numeric prediction column}
\usage{
bound_prediction(
  x,
  lower_limit = -Inf,
  upper_limit = Inf,
  call = rlang::current_env()
)
}
\arguments{
\item{x}{A data frame that contains a numeric column named \code{.pred}.}

\item{lower_limit, upper_limit}{Single numerics (or \code{NA}) that define
constraints on \code{.pred}.}

\item{call}{The call to be displayed in warnings or errors.}
}
\value{
\code{x} with potentially adjusted values.
}
\description{
For user-defined \code{lower_limit} and/or \code{upper_limit} bound, ensure that the values in the
\code{.pred} column are coerced to these bounds.
}
\examples{
data(solubility_test, package = "yardstick")

names(solubility_test) <- c("solubility", ".pred")

bound_prediction(solubility_test, lower_limit = -1)
}
