% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_linear_restrictions.R
\name{test_linear_restrictions}
\alias{test_linear_restrictions}
\title{Test multiple linear restrictions simultaneously}
\usage{
test_linear_restrictions(regresults, R, r = default_test(R))
}
\arguments{
\item{regresults}{A list containing two items: \code{coefficients},
which is a vector of coefficient estimates, and \code{vcov},
which is the variance-covariance matrix of the coefficient estimates.}

\item{R}{A matrix of linear restrictions. Each row of \code{R} represents a
different linear restriction. R should have the same number of columns
as \code{length(regresults$coefficients)}.}

\item{r}{A vector of constants, equal to the number of rows in \code{R}.
This is what we are testing that each linear restriction is equal to.}
}
\value{
A list with the following items:
\itemize{
\item W: The Wald (chi-square) statistic
\item p_value: The p-value of the test
}
}
\description{
\code{test_linear_restrictions} takes a set of regression results and
tests multiple linear restrictions simultaneously.
}
\examples{
\dontshow{if (requireNamespace("estimatr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# test both that the returns to one year of education are
# equal to ten years of age, and that the intercept is zero
model <- estimatr::lm_robust(earnwk ~ age + educ, data = cps)
R <- matrix(c(0, -10, 1, 1, 0, 0), nrow = 2, byrow = TRUE)
test_linear_restrictions(model, R)
\dontshow{\}) # examplesIf}
}
