% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediationBK.R
\name{mediationBK}
\alias{mediationBK}
\title{Perform mediation analysis by Baron and Kenny Method}
\usage{
mediationBK(
  X = NULL,
  M = NULL,
  Y = NULL,
  labels = list(),
  data,
  silent = TRUE,
  indirect.test = TRUE,
  sig = 0.05
)
}
\arguments{
\item{X}{name of independent variable}

\item{M}{name of mediator variable}

\item{Y}{name of dependent variable}

\item{labels}{An optional list of variable names}

\item{data}{A data.frame}

\item{silent}{Logical. Whether or not show summary of regression tests}

\item{indirect.test}{Logical. Whether or not show results of bda.mediation.test}

\item{sig}{significant level. default value is 0.05}
}
\description{
Perform mediation analysis by Baron and Kenny Method
}
\examples{
labels=list(X="cond",M="pmi",Y="reaction")
result=mediationBK(labels=labels,data=pmi,silent=FALSE)
result
}
