% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mpa.R
\name{mpa}
\alias{mpa}
\title{Moderated Profile Analysis}
\usage{
mpa(formula, data, moderator, k = 100, na.action = "na.fail",
  stage2 = FALSE)
}
\arguments{
\item{formula}{An object of class \code{\link{formula}} of the form \code{response ~ terms}.}

\item{data}{An optional data frame, list or environment containing the variables in the model.}

\item{moderator}{Name of the moderator variable.}

\item{k}{Corresponds to the scalar constant and must be greater than 0. Defaults to 100.}

\item{na.action}{How should missing data be handled? Function defaults to failing if missing data are present.}

\item{stage2}{Should stage 2 be executed regardless of stage 1 outcome? defaults to FALSE.}
}
\value{
An object of class \code{critpat} is returned, listing the following components:
\itemize{
 \item \code{r2_full} - the proportion of variability attributed to the full model
 \item \code{r2_red} - the proportion of variability attributed to the reduced model
 \item \code{ftable} - the associated F-statistic table
 \item \code{F-statistic} - the F-statistics
 \item \code{df} - the dfs used in the test
 \item \code{pvalue} - the p-values for the test}
}
\description{
Implements the moderated profile analysis approach developed by Davison & Davenport (unpublished) - EXPERIMENTAL SUPPORT
}
\details{
The function returns the criterion-related moderated profile analysis described in Davison & Davenport (unpublished). Missing data are presently handled by specifying \code{na.action = "na.omit"}, which performs listwise deletion and \code{na.action = "na.fail"}, the default, which causes the function to fail. The following S3 generic functions are not yet available but will be in future implementations. \code{summary()},\code{anova()}, \code{print()}, and \code{plot()}. These functions provide a summary of the analysis (namely, R2 and the level and pattern components); perform ANOVA of the R2 for the pattern, the level, and the overall model; provide output similar to \code{lm()}, and plots the pattern effect.
}
\examples{
\dontrun{
data(mod_data)
mod <- mpa(dv ~ pred1 * mod + pred2 * mod, moderator = "mod", data = mod_data)
}
}
\references{
Davison, M., & Davenport, E. (unpublished). Comparing Criterion-Related Patterns of Predictor Variables across Populations Using Moderated Regression.
}
\seealso{
\code{\link{cpa}}
}
\keyword{method}

