% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtheme.R
\name{theme_profinit}
\alias{theme_profinit}
\title{Profinit ggplot theme}
\usage{
theme_profinit()
}
\value{
Ggplot2's theme object adjusted according to Profinit's preferences.
}
\description{
The current version of the theme is based on \code{ggplot2::theme_minimal()} not
tweaking any of its settings. Later on, the theme will be customised to
better fill our needs and preferences.
}
\examples{
# default behavior
library(ggplot2)
iris_plt <- ggplot(iris, aes(x=Sepal.Length, fill=Species)) +
  geom_density(alpha=.5) +
  scale_fill_profinit()
iris_plt

# With profinit theme
iris_plt + theme_profinit()

}
\seealso{
\link{scale_fill_profinit} and \link{scale_color_profinit} for Profinit color scales.
}
