% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{plot_texts}
\alias{plot_texts}
\title{Plot vectors on a 2D plan}
\usage{
plot_texts(coordinates, min_cluster_size = 5)
}
\arguments{
\item{coordinates}{\link{data.frame} containing 2D coordinates of texts.}

\item{min_cluster_size}{\link{integer} corresponding to the minimum size of a vector (for the colors).}
}
\description{
Plot the text on an interactive scatter plot.
}
\examples{
if(interactive()){
# This example should be run with a higher quality model
# than the one embedded in fastrtext
library(projector)
library(fastrtext)

model_test_path <- system.file("extdata",
                               "model_unsupervised_test.bin",
                               package = "fastrtext")
model <- load_model(model_test_path)
word_embeddings <- get_word_vectors(model,
                                    words = head(get_dictionary(model), 2e5))

annoy_model <- get_annoy_model(word_embeddings, 5)

selected_word <- "out"
df <- retrieve_neighbors(text = selected_word,
                         projection_type = "tsne",
                         annoy_model = annoy_model,
                         n = 1000)
plot_texts(df, 3)
}
}
