% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-projects_stage.R
\docType{class}
\name{projects_stage}
\alias{projects_stage}
\alias{projects_stage-class}
\alias{match.projects_stage}
\alias{match,projects_stage,ANY-method}
\alias{match,ANY,projects_stage-method}
\alias{match,projects_stage,projects_stage-method}
\alias{\%in\%.projects_stage}
\alias{\%in\%,projects_stage-method}
\title{\code{projects_stage} vector}
\usage{
projects_stage(x = character())

match.projects_stage(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{projects_stage,ANY}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{ANY,projects_stage}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{projects_stage,projects_stage}(x, table, nomatch = NA_integer_, incomparables = NULL)

`\%in\%.projects_stage`(x, table)

\S4method{\%in\%}{projects_stage}(x, table)
}
\arguments{
\item{x}{For \code{projects_stage()}, an integer or character vector. For

  For \code{\link{match}()} and \code{\link{\%in\%}}, an integer, a character
  string, or a \code{projects_stage} object. See \code{\link{match}()} and
  \strong{Comparison and value matching methods} below.}

\item{table}{An integer number, a character string, or a
\code{projects_stage} object. See \code{\link{match}()} and
\strong{Comparison and value matching methods} below.}

\item{nomatch}{See \code{\link{match}()}.}

\item{incomparables}{An integer number, a character string, or a
\code{projects_stage} object. See \code{\link{match}()}.}
}
\value{
For \code{projects_stage()}, an S3 vector of class
  \code{projects_stage}.
}
\description{
Objects of this class are merely a character string containing a number and a
name of one of seven project development stages.
}
\details{
A \code{projects_stage} object is either a missing value (\code{NA}) or one
of:

\code{0: idea}\cr \code{1: design}\cr \code{2: data collection}\cr \code{3:
analysis}\cr \code{4: manuscript}\cr \code{5: under review}\cr \code{6:
accepted}

\code{projects_stage()} validates and coerces a vector of the above integers or strings to a \code{projects_stage} S3 vector.
}
\section{Numeric coercion methods}{
 \code{\link{as.integer}()},
  \code{\link{as.double}()}, and \code{\link{as.numeric}()} return the stage
  number of the \code{projects_stage} object as an integer/double. The
  methods for the comparison and value matching functions described below
  make use of these numeric coercion methods. Users desiring to apply value
  matching functions other than the ones described below may similarly take
  advantage of these.
}

\section{Comparison and value matching methods}{
 Methods for the
  \link{Comparison} operators as well as \code{\link{match}()} and
  \code{\link{\%in\%}} enable users to test equality and to value match among
  \code{projects_stage} objects and as well as between \code{projects_stage}
  objects and unclassed numbers/characters. When comparing or value matching
  against a numeric vector, the \code{projects_stage} object is first coerced
  to an integer with the \code{as.integer()} method described above. When
  testing or value matching against a character vector, the character vector
  is validated against the list of project stages enumerated above.
}

\examples{
stage <- projects_stage("4: manuscript")

as.integer(stage) # 4

stage == 4       # TRUE
stage != 4       # FALSE
stage <  6       # TRUE

stage \%in\% c(3:6)  # TRUE
match(stage, 0:4)  # 5

stage \%in\% c("design", "manusc", "idea")  # TRUE

more_stages <- projects_stage(c("0: idea", "4: manuscript", "1: design"))

match("MAnuscRIPT", more_stages)      # 2
}
\seealso{
\code{\link{Ops}}; \code{\link[methods]{Methods_for_Nongenerics}}.
}
