% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit.R
\name{reordering}
\alias{reordering}
\alias{reorder_authors}
\alias{reorder_affiliations}
\title{Reordering authors and affiliations}
\usage{
reorder_authors(project, ..., after = 0L, archived = FALSE)

reorder_affiliations(author, ..., after = 0L)
}
\arguments{
\item{project, author}{The \code{id} or unambiguous names of a project/author
whose authors/affiliations you want to reorder.}

\item{...}{The \code{id}s or names of authors/affiliations you want to
reorder, optionally with their new ranks explicitly stated. See
\strong{Details}.}

\item{after}{If not specifying explicit ranks in \code{...}, the position you
  want the elements to come after. Works like the \code{after} argument in
  \code{\link[base]{append}} or
  \code{forcats::\link[forcats]{fct_relevel}()}.

  Ignored if ranks are explicitly provided in \code{...}.}

\item{archived}{Logical indicating whether or not the function should
  consider archived projects when determining which project the user is
  referring to in the \code{project} argument. \code{FALSE} by default.

  See the \strong{Details} section of \code{\link{archive_project}()} for
  more information on the "archived" status of a project.}
}
\description{
These functions allow the user to reorder a project's authors or an author's
affiliations.
}
\details{
The order of authors and affiliations affects the order in which these items
appear in the output of \code{\link{header}()}.

When specifying explicit ranks, enter \code{...} as name-value pairs (e.g.,
Johnson = 2, "Baron Cohen" = 4). You can even enumerate authors/affiliations
by their corresponding (quoted) \code{id} numbers (e.g., `7` = 2, ACME = 4,
`22` = 6). If entering an integer greater than the total number of
authors/affiliations, the element will be put at the end. The \code{after}
argument will be ignored in this case.

When not specifying explicit ranks, simply enter author/affiliations
\code{id}s or names in the order you want them, and the ones you entered will
be inserted after the position specified by the \code{after} argument. By
default (\code{after = 0}), the authors/affiliations in \code{...} will be
moved to the front. This behavior corresponds to that of
\code{\link{append}()} or \code{forcats::\link[forcats]{fct_relevel}()}.
}
\examples{
#############################################################################
# SETUP
old_home <- Sys.getenv("HOME")
old_ppath <- Sys.getenv("PROJECTS_FOLDER_PATH")
temp_dir <- tempfile("dir")
dir.create(temp_dir)
Sys.unsetenv("PROJECTS_FOLDER_PATH")
Sys.setenv(HOME = temp_dir)
setup_projects(path = temp_dir)
new_affiliation(department_name = "Math Dept.",
                institution_name = "Springfield College",
                address = "123 College St, Springfield, AB")
new_affiliation(department_name = "Art Department",
                institution_name = "Springfield College",
                address = "321 University Boulevard, Springfield, AB",
                id = 42)
new_affiliation(department_name = "Central Intelligence Agency",
                institution_name = "United States Government",
                address = "888 Classified Dr, Washington DC")
new_affiliation(department_name = "Pyrotechnics",
                institution_name = "ACME")
new_author(given_names = "Rosetta", last_name = "Stone",
           affiliations = c(42, "Math"), degree = "PhD",
           email = "slab@rock.net", phone = "867-555-5309", id = 8888)
new_author(given_names = "Spiro", last_name = "Agnew", degree = "LLB",
           affiliations = "Art D", id = 13)
new_author(given_names = "Plato", id = 303)
new_author(given_names = "Condoleezza", last_name = "Rice", degree = "PhD",
           affiliations = c(1, 42, "Agency", "ACME"), phone = "555-555-5555",
           email = "condoleeza@ri.ce")
new_author(given_names = "Jane", last_name = "Goodall", degree = "PhD",
           affiliations = 3, id = 5)
new_project(title = "Understanding the Construction of the United States",
            short_title = "USA",
            authors = c(13, "Stone", "zz", "303", "Jane Goodall"),
            stage = 4, deadline = "2055-02-28", deadline_type = "submission",
            parent_directory = "famous_studied/philosophers/rocks",
            corresp_auth = "Stone", current_owner = "agnew",
            make_directories = TRUE,
            status = "waiting on IRB")
#############################################################################

# Rice's affiliations before reordering:
authors("rice", affiliations = TRUE)

# Reordering (with unnamed arguments)
reorder_affiliations(author = "RICE", "ACME", 42, after = 1)

# Rice's affiliations after reordering:
authors("rice", affiliations = TRUE)

# Project 1 header before reordering authors:
header(1)

# Reordering (with named arguments)
reorder_authors(project = 1, "Rosetta" = 99, `303` = 2, "5" = 1)

# Project 1 header after reordering authors:
header(1)

#############################################################################
# CLEANUP
Sys.setenv(HOME = old_home, PROJECTS_FOLDER_PATH = old_ppath)
}
