% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project}
\alias{project}
\title{Projection to submodels of selected sizes}
\usage{
project(object, nv = NULL, vind = NULL, ns = NULL, nc = NULL,
  intercept = NULL, seed = NULL, regul = 1e-06, ...)
}
\arguments{
\item{object}{The object returned by \link[=varsel]{varsel} or
\link[=cv_varsel]{cv_varsel}.}

\item{nv}{Number of variables in the submodel (the variable combination is taken from the
\code{varsel} information). If a list, then the projection is performed for each model size.
Default is all model sizes up to the maximum number of variables in \code{varsel}.
 Ignored if \code{vind} is specified.}

\item{vind}{Variable indices onto which the projection is done. If specified, \code{nv} is ignored.}

\item{ns}{Number of samples to be projected. Ignored if \code{nc} is specified. Default is 400.}

\item{nc}{Number of clusters in the clustered projection.}

\item{intercept}{Whether to use intercept. Default is \code{TRUE}.}

\item{seed}{A seed used in the clustering (if \code{nc!=ns}). Can be used
to ensure same results every time.}

\item{regul}{Amount of regularization in the projection. Usually there is no need for
regularization, but sometimes for some models the projection can be ill-behaved and we
need to add some regularization to avoid numerical problems. Default is 1e-9.}

\item{...}{Currently ignored.}
}
\value{
A list of submodels (or a single submodel if projection was performed onto
a single variable combination), each of which contain the following elements:
\describe{
 \item{\code{kl}}{The kl divergence from the full model to the submodel.}
 \item{\code{weights}}{Weights for each draw of the projected model.}
 \item{\code{dis}}{Draws from the projected dispersion parameter.}
 \item{\code{alpha}}{Draws from the projected intercept.}
 \item{\code{beta}}{Draws from the projected weight vector.}
 \item{\code{vind}}{The order in which the variables were added to the submodel.}
 \item{\code{intercept}}{Whether or not the model contains an intercept.}
 \item{\code{family_kl}}{A modified \code{\link{family}}-object.}
}
}
\description{
Perform the projection predictive variable selection for a generalized
linear model fitted with rstanarm.
}
\examples{
\donttest{
### Usage with stanreg objects
fit <- stan_glm(y~x, binomial())
fit_v <- varsel(fit)
proj4 <- project(fit_v, nv = 4)
}

}
