% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SandwichLayerVariance.R
\name{.get_a22_inverse}
\alias{.get_a22_inverse}
\alias{.get_a11_inverse}
\alias{.get_a21}
\alias{.get_tilde_a22_inverse}
\alias{.get_tilde_a21}
\title{(Internal) Estimate components of the sandwich covariance matrix
returned by \code{vcov_tee()}}
\usage{
.get_a22_inverse(x, ...)

.get_a11_inverse(x)

.get_a21(x, ...)

.get_tilde_a22_inverse(x, ...)

.get_tilde_a21(x)
}
\arguments{
\item{x}{a fitted \code{teeMod} model}

\item{...}{arguments passed to \code{bread} method}
}
\value{
\code{.get_a22_inverse()}/\code{.get_tilde_a22_inverse()}: A
\eqn{2\times 2} matrix corresponding to an intercept and the treatment
variable in the direct adjustment model

\code{.get_a11_inverse()}: A \eqn{p\times p} matrix where \eqn{p} is
the dimension of the covariance adjustment model, including an intercept

\code{.get_a21()}/\code{.get_tilde_a21()}: A \eqn{2\times p} matrix
where the number of rows are given by the intercept and the treatment
variable in the direct adjustment model, and the number of columns are
given by the dimension of the covariance adjustment model
}
\description{
(Internal) Estimate components of the sandwich covariance matrix
returned by \code{vcov_tee()}
}
\details{
\code{.get_a22_inverse()}/\code{.get_tilde_a22_inverse()}:
\eqn{A_{22}^{-1}} is the "bread" of the sandwich covariance matrix returned
by \code{vcov_tee()} whether one has fit a prior covariance adjustment
model or not.

\code{.get_a11_inverse()}: \eqn{A_{11}^{-1}} is the "bread" of the
sandwich covariance matrix for the covariance adjustment model. This matrix
contributes to the meat matrix of the direct adjustment sandwich covariance
matrix.

\code{.get_a21()}/\code{.get_tilde_a21()}: \eqn{A_{21}} is the
gradient of the estimating equations for the direct adjustment model taken
with respect to the covariance adjustment model parameters. This matrix is
the crossproduct of the prediction gradient for the units of observation in
\eqn{\mathcal{Q}} and the model matrix of the direct adjustment model.
}
\keyword{internal}
