% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prophet.R
\name{predict.prophet}
\alias{predict.prophet}
\title{Predict using the prophet model.}
\usage{
\method{predict}{prophet}(object, df = NULL, ...)
}
\arguments{
\item{object}{Prophet object.}

\item{df}{Dataframe with dates for predictions, and capacity if logistic
growth. If not provided, predictions are made on the history.}

\item{...}{additional arguments}
}
\value{
A data_frame with a forecast
}
\description{
Predict using the prophet model.
}
\examples{
\dontrun{
history <- data.frame(ds = seq(as.Date('2015-01-01'), as.Date('2016-01-01'), by = 'd'),
                      y = sin(1:366/200) + rnorm(366)/10)
m <- prophet(history)
future <- make_future_dataframe(m, periods = 365)
forecast <- predict(m, future)
plot(m, forecast)
}

}

