% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{simulated_historical_forecasts}
\alias{simulated_historical_forecasts}
\title{Simulated historical forecasts.}
\usage{
simulated_historical_forecasts(model, horizon, units, k, period = NULL)
}
\arguments{
\item{model}{Fitted Prophet model.}

\item{horizon}{Integer size of the horizon}

\item{units}{String unit of the horizon, e.g., "days", "secs".}

\item{k}{integer number of forecast points}

\item{period}{Integer amount of time between cutoff dates. Same units as
horizon. If not provided, will use 0.5 * horizon.}
}
\value{
A dataframe with the forecast, actual value, and cutoff date.
}
\description{
Make forecasts from k historical cutoff points, working backwards from
(end - horizon) with a spacing of period between each cutoff.
}

