% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/102.Confidence_base_n_Graph.R
\name{PlotciEX}
\alias{PlotciEX}
\title{Plots the CI estimation of exact methods}
\usage{
PlotciEX(n, alp, e)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{e}{- Exact method indicator  in [0, 1] {1: Clopper Pearson, 0.5: Mid P},
The input can also be a range of values between 0 and 1.}
}
\description{
Plots the CI estimation of exact methods
}
\details{
The plot of Confidence Interval of \code{n} given \code{alp}.
}
\examples{
\dontrun{
n=5; alp=0.05; e=0.5 #Mid-p
PlotciEX(n,alp,e)
n=5; alp=0.05;e=1 #Clopper-Pearson
PlotciEX(n,alp,e)
n=5; alp=0.05;e=c(0.05,0.1,0.5,0.95,1) #Range including Mid-p and Clopper-Pearson
PlotciEX(n,alp,e)
}
}
\seealso{
Other Basic methods of CI estimation: \code{\link{PlotciAS}},
  \code{\link{PlotciAllg}}, \code{\link{PlotciAll}},
  \code{\link{PlotciBA}}, \code{\link{PlotciLR}},
  \code{\link{PlotciLT}}, \code{\link{PlotciSC}},
  \code{\link{PlotciTW}}, \code{\link{PlotciWD}},
  \code{\link{ciAS}}, \code{\link{ciAll}},
  \code{\link{ciBA}}, \code{\link{ciEX}},
  \code{\link{ciLR}}, \code{\link{ciLT}},
  \code{\link{ciSC}}, \code{\link{ciTW}},
  \code{\link{ciWD}}
}

