% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/111.ConfidenceIntervals_ADJ_n.R
\name{ciALT}
\alias{ciALT}
\title{Adjusted Logit-Wald method of CI estimation}
\usage{
ciALT(n, alp, h)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{h}{- adding factor}
}
\value{
A dataframe with
 \item{x}{  Number of successes (positive samples)}
 \item{LALT }{   Adjusted Logit-Wald Lower limit}
 \item{UALT }{   Adjusted Logit-Wald Upper Limit}
 \item{LABB }{   Adjusted Logit-Wald Lower Abberation}
 \item{UABB }{   Adjusted Logit-Wald Upper Abberation}
 \item{ZWI }{   Zero Width Interval}
}
\description{
Adjusted Logit-Wald method of CI estimation
}
\details{
Wald-type interval for the logit transformation \eqn{log(p/1-p)}
 of the parameter \code{p} for the modified data \eqn{x + h} and \eqn{n + (2*h)},
 where \eqn{h > 0} and for all \eqn{x = 0, 1, 2 ..n.}
}
\examples{
n=5; alp=0.05;h=2
ciALT(n,alp,h)
}
\references{
[1] 1998 Agresti A and Coull BA.
Approximate is better than "Exact" for interval estimation of binomial proportions.
The American Statistician: 52; 119 - 126.

[2] 1998 Newcombe RG.
Two-sided confidence intervals for the single proportion: Comparison of seven methods.
Statistics in Medicine: 17; 857 - 872.

[3] 2008 Pires, A.M., Amado, C.
Interval Estimators for a Binomial Proportion: Comparison of Twenty Methods.
REVSTAT - Statistical Journal, 6, 165-197.
}
\seealso{
\code{\link{prop.test} and \link{binom.test}} for equivalent base Stats R functionality,
   \code{\link[binom]{binom.confint}}  provides similar functionality for 11 methods,
   \code{\link[PropCIs]{wald2ci}} which provides multiple functions for CI calculation ,
   \code{\link[BlakerCI]{binom.blaker.limits}} which calculates Blaker CI which is not covered here and
   \code{\link[prevalence]{propCI}} which provides similar functionality.

Other Adjusted methods of CI estimation: \code{\link{PlotciAAS}},
  \code{\link{PlotciAAllg}}, \code{\link{PlotciAAll}},
  \code{\link{PlotciALR}}, \code{\link{PlotciALT}},
  \code{\link{PlotciASC}}, \code{\link{PlotciATW}},
  \code{\link{PlotciAWD}}, \code{\link{ciAAS}},
  \code{\link{ciAAll}}, \code{\link{ciALR}},
  \code{\link{ciASC}}, \code{\link{ciATW}},
  \code{\link{ciAWD}}
}

