% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{bucket}
\alias{bucket}
\title{Make Bucket Plot}
\usage{
bucket(rho, group, k, prompt = TRUE)
}
\arguments{
\item{rho}{A \code{propr} object created from \code{\link{perb}}.}

\item{group}{A character vector. Group or sub-group memberships,
ordered according to the column names in \code{@counts} and
\code{@logratio}. Parameter required for \code{\link{bucket}}
and optional for \code{\link{mds}}.}

\item{k}{A numeric scalar. The number of groups into which to
cluster the subjects. Clusters calculated  using \code{hclust}.
Optional parameter for \code{\link{bucket}}, \code{\link{prism}},
and \code{\link{bokeh}}.}

\item{prompt}{A logical scalar. Set to \code{FALSE} to disable
the prompt when plotting a large number of features.}
}
\value{
Returns cluster membership if \code{k} is provided.
}
\description{
Plots an estimation of the degree to which a feature pair
 differentiates the experimental groups versus the
 measure of the proportionality between that feature pair.
}
\details{
Providing the argument \code{k} will color feature pairs
 by co-cluster membership. In other words, a feature pair
 will receive a color if and only if both features belong
 to same the cluster (calculated using \code{hclust}).

"It's pronounced, 'bouquet'." - Hyacinth Bucket
}

