% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_median_intensities.R
\name{qc_median_intensities}
\alias{qc_median_intensities}
\title{Median run intensities}
\usage{
qc_median_intensities(
  data,
  sample,
  grouping,
  intensity,
  plot = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame containing at least the input variables.}

\item{sample}{the name of the column containing the sample names.}

\item{grouping}{the name of the column containing precursor or peptide identifiers.}

\item{intensity}{the name of the column containing intensity values. The intensity should be ideally log2 transformed, but also non-transformed values can be used.}

\item{plot}{logical, if TRUE a plot is returned. If FALSE a table is returned.}

\item{interactive}{logical, if TRUE the plot is interactive using plotly.}
}
\value{
A plot that displays median intensity over all samples. If \code{plot = FALSE} a data frame containing median intensities is returned.
}
\description{
Median intensities per run are returned either as a plot or a table.
}
\examples{
\dontrun{
qc_median_intensities(
  data,
  sample = r_file_name,
  grouping = eg_precursor_id,
  intensity = log2_intensity
)
}
}
