% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_ids.R
\name{qc_ids}
\alias{qc_ids}
\title{Check number of precursor, peptide or protein IDs}
\usage{
qc_ids(
  data,
  sample,
  grouping,
  intensity,
  remove_na_intensities = TRUE,
  condition = NULL,
  title = "ID count per sample",
  plot = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame containing at least sample names and precursor/peptide/protein IDs.}

\item{sample}{a character column in the \code{data} data frame that contains the sample name.}

\item{grouping}{a character column in the \code{data} data frame that contains either precursor or
peptide identifiers.}

\item{intensity}{a character column in the \code{data} data frame that contains raw or log2
transformed intensities. If \code{remove_na_intensities = FALSE}, this argument is optional.}

\item{remove_na_intensities}{a logical value that specifies if sample/grouping combinations with
intensities that are NA (not quantified IDs) should be dropped from the data frame. Default is
TRUE since we are usually interested in the number of quantifiable IDs.}

\item{condition}{optional, a column in the \code{data} data frame that contains condition information
(e.g. "treated" and "control"). If this column is provided, the bars in the plot will be coloured
according to the condition.}

\item{title}{optional, a character value that specifies the plot title (default is "ID count
per sample").}

\item{plot}{a logical value that indicates whether the result should be plotted.}

\item{interactive}{a logical value that specifies whether the plot should be interactive
(default is FALSE).}
}
\value{
A bar plot with the height corresponding to the number of IDs, each bar represents one
sample (if \code{plot = TRUE}). If \code{plot = FALSE} a table with ID counts is returned.
}
\description{
Returns a plot or table of the number of IDs for each sample. The default settings remove
grouping variables without quantitative information (intensity is NA). These will not be
counted as IDs.
}
\examples{
set.seed(123) # Makes example reproducible

# Create example data
data <- create_synthetic_data(
  n_proteins = 100,
  frac_change = 0.05,
  n_replicates = 3,
  n_conditions = 2,
  method = "effect_random"
)

# Calculate number of identifications
qc_ids(
  data = data,
  sample = sample,
  grouping = peptide,
  intensity = peptide_intensity_missing,
  condition = condition,
  plot = FALSE
)

# Plot number of identifications
qc_ids(
  data = data,
  sample = sample,
  grouping = peptide,
  intensity = peptide_intensity_missing,
  condition = condition,
  plot = TRUE
)
}
