% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_quickgo.R
\name{fetch_quickgo}
\alias{fetch_quickgo}
\title{Fetch information from the QuickGO API}
\usage{
fetch_quickgo(
  type = "annotations",
  id_annotations = NULL,
  taxon_id_annotations = NULL,
  ontology_annotations = "all",
  go_id_slims = NULL,
  relations_slims = c("is_a", "part_of", "regulates", "occurs_in"),
  show_progress = TRUE
)
}
\arguments{
\item{type}{a character value that indicates if gene ontology terms, annotations or slims
should be retrieved. The possible values therefore include "annotations", "terms" and "slims".
If annotations are retrieved, the maximum number of results is 2,000,000.}

\item{id_annotations}{an optional character vector that specifies UniProt IDs for which GO annotations
should be retrieved. This argument should only be provided if annotations are retrieved.}

\item{taxon_id_annotations}{an optional character value that specifies the NCBI taxonomy identifier (TaxId)
for an organism for which GO annotations should be retrieved.
This argument should only be provided if annotations are retrieved.}

\item{ontology_annotations}{an optional character value that specifies the ontology that should be retrieved.
This can either have the values "all", "molecular_function", "biological_process" or
"cellular_component". This argument should only be provided if annotations are retrieved.}

\item{go_id_slims}{an optional character vector that specifies gene ontology IDs (e.g. GO:0046872) for which
a slim go set should be generated. This argument should only be provided if slims are retrieved.}

\item{relations_slims}{an optional character vector that specifies the relations of GO IDs that should be
considered for the generation of the slim dataset. This argument should only be provided if slims are retrieved.}

\item{show_progress}{a logical value that indicates if a progress bar will be shown.
Default is TRUE.}
}
\value{
A data frame that contains descriptive information about gene ontology annotations, terms or slims
depending on what the input "type" was.
}
\description{
Fetches gene ontology (GO) annotations, terms or slims from the QuickGO EBI database.
Annotations can be retrieved for specific UniProt IDs or NCBI taxonomy identifiers. When
terms are retrieved, a complete list of all GO terms is returned. For the generation of
a slim dataset you can provide GO IDs that should be considered. A slim dataset is a subset
GO dataset that considers all child terms of the supplied IDs.
}
\examples{
\donttest{
# Annotations
annotations <- fetch_quickgo(type = "annotations", 
                             id = c("P63328","Q4FFP4"), 
                             ontology = "molecular_function")

head(annotations)

# Terms
terms <- fetch_quickgo(type = "terms")

head(terms)

# Slims
slims <- fetch_quickgo(type = "slims", 
                       go_id_slims = c("GO:0046872", "GO:0051540"))

head(slims)
}
}
