/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.files.diff.MergeResult;
import com.qarks.util.files.diff.MergeResultItem;
import com.qarks.util.files.diff.ui.FileMergeMonitorDialog;
import com.qarks.util.files.diff.ui.FileOverview;
import com.qarks.util.files.diff.ui.LineCellRenderer;
import com.qarks.util.files.diff.ui.MergeContentPanel;
import com.qarks.util.files.diff.ui.MergeInputDialog;
import com.qarks.util.files.diff.ui.MergeOverview;
import com.qarks.util.files.diff.ui.MergePanelItem;
import com.qarks.util.files.diff.ui.OriginalMergePanelItem;
import com.qarks.util.files.diff.ui.ResourceKeyDiff;
import com.qarks.util.stream.FileHelper;
import com.qarks.util.ui.CharsetCombo;
import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.swing.FileDropHandler;
import com.qarks.util.ui.swing.FileDropListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MergePanel
extends JPanel
implements FileDropListener {
    private CharsetCombo charsetChooser;
    private JCheckBox ignoreLeadingSpaces;
    private MergeContentPanel mergePanel;
    private FileOverview leftFileOverview;
    private FileOverview rightFileOverview;
    private JLabel commentLabel;
    private MergeContentPanel originalLeft;
    private MergeContentPanel originalRight;
    private JScrollPane scroll1;
    private JScrollPane scroll2;
    private JScrollPane scroll3;
    private boolean scrolling = false;
    private File[] files = null;
    private LineCellRenderer leftRenderer;
    private LineCellRenderer rightRenderer;
    private JScrollBar mergeHorScrollBar;
    private MergeOverview mergeOverview;
    private TitledBorder leftTitleBorder;
    private TitledBorder rightTitleBorder;
    private JPanel mergeDetailsPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel centerPanel;
    private JCheckBox verticalSplit;
    private JPanel externalToolbarPanel;
    private JPanel optionsPanel;
    private JPanel toolbar;
    private JComboBox eolCombo;

    public MergePanel(String string, String string2, String string3) {
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.add((Component)jPanel, "Center");
        this.commentLabel = new JLabel("");
        this.originalLeft = new MergeContentPanel();
        this.originalRight = new MergeContentPanel();
        this.leftRenderer = new LineCellRenderer();
        this.rightRenderer = new LineCellRenderer();
        this.scroll1 = new JScrollPane(this.originalLeft);
        this.scroll2 = new JScrollPane(this.originalRight);
        this.leftFileOverview = new FileOverview();
        this.rightFileOverview = new FileOverview();
        this.mergeOverview = new MergeOverview();
        this.charsetChooser = new CharsetCombo();
        this.charsetChooser.select(string3);
        this.ignoreLeadingSpaces = new JCheckBox(ResourceManager.getString((Object)ResourceKeyDiff.IGNORE_LEADING));
        this.externalToolbarPanel = new JPanel(new FlowLayout(2, 5, 5));
        this.verticalSplit = new JCheckBox(ResourceManager.getString((Object)ResourceKeyDiff.VERTICAL_SPLIT));
        this.leftPanel = new JPanel(new BorderLayout(5, 5));
        this.leftPanel.add((Component)this.scroll1, "Center");
        this.leftPanel.add((Component)this.leftFileOverview, "East");
        this.leftTitleBorder = new TitledBorder(string);
        this.leftPanel.setBorder(this.leftTitleBorder);
        this.rightPanel = new JPanel(new BorderLayout(5, 5));
        this.rightPanel.add((Component)this.scroll2, "Center");
        this.rightPanel.add((Component)this.rightFileOverview, "East");
        this.rightTitleBorder = new TitledBorder(string2);
        this.rightPanel.setBorder(this.rightTitleBorder);
        this.mergePanel = new MergeContentPanel();
        this.mergeHorScrollBar = new JScrollBar(0);
        this.mergeHorScrollBar.setVisible(false);
        this.scroll3 = new JScrollPane(this.mergePanel);
        this.scroll3.setHorizontalScrollBarPolicy(31);
        this.centerPanel = new JPanel(new BorderLayout(5, 0));
        this.centerPanel.add((Component)this.scroll3, "Center");
        this.centerPanel.add((Component)this.mergeHorScrollBar, "South");
        this.centerPanel.add((Component)this.mergeOverview, "East");
        this.centerPanel.setBorder(new TitledBorder(ResourceManager.getString((Object)ResourceKeyDiff.MERGED_FILE)));
        this.mergeDetailsPanel = new JPanel(new GridLayout(1, 3, 10, 10));
        this.mergeDetailsPanel.add((Component)this.leftPanel, 0);
        this.mergeDetailsPanel.add((Component)this.centerPanel, 1);
        this.mergeDetailsPanel.add((Component)this.rightPanel, 2);
        this.eolCombo = new JComboBox();
        this.eolCombo.addItem(ResourceManager.getString((Object)ResourceKeyDiff.EOL_WIN));
        this.eolCombo.addItem(ResourceManager.getString((Object)ResourceKeyDiff.EOL_UNIX));
        String string4 = System.getProperty("line.separator");
        if ("\n".equals(string4)) {
            this.eolCombo.setSelectedIndex(1);
        }
        jPanel.add((Component)this.mergeDetailsPanel, "Center");
        this.toolbar = new JPanel(new FlowLayout(0, 5, 5));
        this.toolbar.setVisible(false);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel(new GridLayout(4, 1, 1, 1));
        JPanel jPanel4 = new JPanel(new GridLayout(4, 1, 1, 1));
        jPanel2.add((Component)jPanel3, "West");
        jPanel2.add((Component)jPanel4, "Center");
        jPanel3.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKeyDiff.CURRENT_CHARSET)), "West");
        jPanel4.add((Component)this.charsetChooser, "Center");
        jPanel3.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKeyDiff.MERGE_WITH_EOL)), "West");
        jPanel4.add((Component)this.eolCombo, "Center");
        jPanel3.add(this.ignoreLeadingSpaces);
        jPanel3.add(this.verticalSplit);
        this.toolbar.add(jPanel2);
        this.optionsPanel = new JPanel(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(ResourceManager.getString((Object)ResourceKeyDiff.OPTIONS));
        jLabel.setForeground(Color.blue);
        this.optionsPanel.add((Component)jLabel, "North");
        this.optionsPanel.add((Component)this.toolbar, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
        jPanel5.add((Component)this.optionsPanel, "North");
        jPanel5.add((Component)this.commentLabel, "South");
        JPanel jPanel6 = new JPanel(new BorderLayout(5, 5));
        jPanel6.add((Component)jPanel5, "West");
        this.add((Component)jPanel6, "South");
        JPanel jPanel7 = new JPanel(new BorderLayout(5, 5));
        jPanel7.add((Component)this.externalToolbarPanel, "West");
        jPanel.add((Component)jPanel7, "North");
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    boolean bl = MergePanel.this.isIncluded(MergePanel.this.optionsPanel, mouseEvent);
                    MergePanel.this.showOptions(bl);
                }
            }
        }, 32L);
        this.verticalSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MergePanel.this.verticalSplit.isSelected()) {
                    MergePanel.this.mergeDetailsPanel.removeAll();
                    MergePanel.this.mergeDetailsPanel.setLayout(new GridLayout(2, 1, 10, 10));
                    JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
                    jPanel.add((Component)MergePanel.this.leftPanel, 0);
                    jPanel.add((Component)MergePanel.this.rightPanel, 1);
                    MergePanel.this.mergeDetailsPanel.add((Component)jPanel, 0);
                    MergePanel.this.mergeDetailsPanel.add((Component)MergePanel.this.centerPanel, 1);
                } else {
                    MergePanel.this.mergeDetailsPanel.removeAll();
                    MergePanel.this.mergeDetailsPanel.setLayout(new GridLayout(1, 3, 10, 10));
                    MergePanel.this.mergeDetailsPanel.add((Component)MergePanel.this.leftPanel, 0);
                    MergePanel.this.mergeDetailsPanel.add((Component)MergePanel.this.centerPanel, 1);
                    MergePanel.this.mergeDetailsPanel.add((Component)MergePanel.this.rightPanel, 2);
                }
                MergePanel.this.mergeDetailsPanel.invalidate();
                MergePanel.this.validate();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MergePanel.this.onPanelResized();
            }
        });
        this.mergeHorScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                MergePanel.this.onMergePanelHorScrollValueChanged(MergePanel.this.mergeHorScrollBar.getValue());
            }
        });
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (MergePanel.this.files != null) {
                    MergePanel.this.onFileDropped(MergePanel.this.files);
                }
            }
        };
        this.ignoreLeadingSpaces.addItemListener(itemListener);
        this.charsetChooser.addItemListener(itemListener);
        this.scroll1.getVerticalScrollBar().setUnitIncrement(25);
        this.scroll2.getVerticalScrollBar().setUnitIncrement(25);
        this.scroll3.getVerticalScrollBar().setUnitIncrement(25);
        this.scroll1.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!MergePanel.this.scrolling) {
                    MergePanel.this.scrolling = true;
                    MergePanel.this.scroll2.getVerticalScrollBar().setValue(MergePanel.this.scroll1.getVerticalScrollBar().getValue());
                    MergePanel.this.scroll3.getVerticalScrollBar().setValue(MergePanel.this.scroll1.getVerticalScrollBar().getValue());
                    MergePanel.this.scrolling = false;
                }
            }
        });
        this.scroll2.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!MergePanel.this.scrolling) {
                    MergePanel.this.scrolling = true;
                    MergePanel.this.scroll1.getVerticalScrollBar().setValue(MergePanel.this.scroll2.getVerticalScrollBar().getValue());
                    MergePanel.this.scroll3.getVerticalScrollBar().setValue(MergePanel.this.scroll2.getVerticalScrollBar().getValue());
                    MergePanel.this.scrolling = false;
                }
            }
        });
        this.scroll3.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!MergePanel.this.scrolling) {
                    MergePanel.this.scrolling = true;
                    MergePanel.this.scroll1.getVerticalScrollBar().setValue(MergePanel.this.scroll3.getVerticalScrollBar().getValue());
                    MergePanel.this.scroll2.getVerticalScrollBar().setValue(MergePanel.this.scroll3.getVerticalScrollBar().getValue());
                    MergePanel.this.scrolling = false;
                }
            }
        });
        this.scroll1.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!MergePanel.this.scrolling) {
                    MergePanel.this.scrolling = true;
                    MergePanel.this.scroll2.getHorizontalScrollBar().setValue(MergePanel.this.scroll1.getHorizontalScrollBar().getValue());
                    MergePanel.this.mergeHorScrollBar.setValue(MergePanel.this.scroll1.getHorizontalScrollBar().getValue());
                    MergePanel.this.scrolling = false;
                }
            }
        });
        this.scroll2.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!MergePanel.this.scrolling) {
                    MergePanel.this.scrolling = true;
                    MergePanel.this.scroll1.getHorizontalScrollBar().setValue(MergePanel.this.scroll2.getHorizontalScrollBar().getValue());
                    MergePanel.this.mergeHorScrollBar.setValue(MergePanel.this.scroll2.getHorizontalScrollBar().getValue());
                    MergePanel.this.scrolling = false;
                }
            }
        });
        this.mergeHorScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!MergePanel.this.scrolling) {
                    MergePanel.this.scrolling = true;
                    MergePanel.this.scroll1.getHorizontalScrollBar().setValue(MergePanel.this.mergeHorScrollBar.getValue());
                    MergePanel.this.scroll2.getHorizontalScrollBar().setValue(MergePanel.this.mergeHorScrollBar.getValue());
                    MergePanel.this.scrolling = false;
                }
            }
        });
    }

    private void showOptions(boolean bl) {
        this.toolbar.setVisible(bl);
        this.optionsPanel.invalidate();
        this.validate();
    }

    private boolean isIncluded(Container container, MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.optionsPanel.isShowing()) {
            Point point = mouseEvent.getLocationOnScreen();
            Point point2 = this.optionsPanel.getLocationOnScreen();
            Dimension dimension = this.optionsPanel.getSize();
            if (point.x > point2.x && point.x < point2.x + dimension.width && point.y > point2.y && point.y < point2.y + dimension.height) {
                bl = true;
            }
        }
        return bl;
    }

    public void addExternalButton(JButton jButton) {
        this.externalToolbarPanel.add(jButton);
    }

    public void enableFileDrop() {
        FileDropHandler.addFileDropListener(this.originalLeft, this);
        FileDropHandler.addFileDropListener(this.originalRight, this);
        FileDropHandler.addFileDropListener(this.mergePanel, this);
    }

    public Charset getSelectedCharset() {
        return this.charsetChooser.getSelectedCharset();
    }

    @Override
    public void onFileDropped(File[] fileArray) {
        this.files = fileArray;
        try {
            if (fileArray.length == 3) {
                Window window = SwingUtilities.getWindowAncestor(this.originalLeft);
                this.leftTitleBorder.setTitle(fileArray[0].getName());
                this.rightTitleBorder.setTitle(fileArray[1].getName());
                this.repaint();
                String string = FileHelper.getFileContent(fileArray[0], this.getSelectedCharset().name());
                String string2 = FileHelper.getFileContent(fileArray[1], this.getSelectedCharset().name());
                String string3 = FileHelper.getFileContent(fileArray[2], this.getSelectedCharset().name());
                FileMergeMonitorDialog fileMergeMonitorDialog = new FileMergeMonitorDialog(window, string3, string, string2, this.ignoreLeadingSpaces.isSelected(), this);
                fileMergeMonitorDialog.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void launchMerge(File file, File file2, File file3) {
        this.onFileDropped(new File[]{file, file2, file3});
    }

    public void openInputDialog(Window window, String string, String string2, String string3) {
        MergeInputDialog mergeInputDialog = new MergeInputDialog(window, string, string2, string3);
        DialogUtilities.centerWindow(mergeInputDialog, window);
        if (!mergeInputDialog.isCancelled()) {
            File file = new File(mergeInputDialog.getLeftFilePath());
            File file2 = new File(mergeInputDialog.getRightFilePath());
            File file3 = new File(mergeInputDialog.getCommonFilePath());
            this.onFileDropped(new File[]{file, file2, file3});
        }
    }

    private void onPanelResized() {
        Dimension dimension = this.mergePanel.getRealPreferredSize();
        Rectangle rectangle = this.scroll3.getVisibleRect();
        Dimension dimension2 = new Dimension(rectangle.width, dimension.height);
        this.mergePanel.setSize(dimension2);
        this.scroll3.getViewport().setSize(dimension2);
        int n = dimension.width - rectangle.width;
        this.mergeHorScrollBar.setVisible(n > 0);
        this.mergeHorScrollBar.setMaximum(n);
        this.mergeHorScrollBar.setMinimum(0);
        this.mergeHorScrollBar.setValue(0);
    }

    private void onMergePanelHorScrollValueChanged(int n) {
        this.mergePanel.setViewPosition(n);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Font font = this.getFont();
        this.leftRenderer.setFont(font.deriveFont(0));
        this.rightRenderer.setFont(font.deriveFont(0));
    }

    public String getMergedFileContent() {
        String string = this.mergePanel.getMergedFileContent();
        string = this.convertEol(string);
        return string;
    }

    private String convertEol(String string) {
        switch (this.eolCombo.getSelectedIndex()) {
            case 0: {
                string = string.replaceAll("\r\n", "\n");
                string = string.replaceAll("\r", "\n");
                string = string.replaceAll("\n", "\r\n");
                break;
            }
            case 1: {
                string = string.replaceAll("\r\n", "\n");
                string = string.replaceAll("\r", "\n");
            }
        }
        return string;
    }

    public void setContent(MergeResult mergeResult) {
        this.leftFileOverview.setParsedFile(mergeResult.getLeftFile());
        this.rightFileOverview.setParsedFile(mergeResult.getRightFile());
        this.mergeOverview.clear();
        this.originalLeft.clear();
        this.originalRight.clear();
        this.mergePanel.clear();
        int n = 0;
        int n2 = 0;
        for (MergeResultItem mergeResultItem : mergeResult.getMergeItems()) {
            OriginalMergePanelItem originalMergePanelItem = new OriginalMergePanelItem(mergeResultItem.getLeftVersion());
            OriginalMergePanelItem originalMergePanelItem2 = new OriginalMergePanelItem(mergeResultItem.getRightVersion());
            MergePanelItem mergePanelItem = null;
            if (mergeResultItem.getType() == MergeResultItem.Type.NO_CONFLICT) {
                boolean bl = mergeResultItem.getDefaultVersion() == MergeResultItem.DefaultVersion.LEFT;
                mergePanelItem = new MergePanelItem(mergeResultItem.getLeftVersion(), mergeResultItem.getRightVersion(), mergeResultItem.getLineCount(), bl, MergePanelItem.Type.NO_CONFLICT, originalMergePanelItem, originalMergePanelItem2);
                this.mergePanel.addMergeItem(mergePanelItem);
                this.mergeOverview.addInterval(mergeResultItem.getLineCount(), 1);
            } else if (mergeResultItem.getType() == MergeResultItem.Type.CONFLICT) {
                ++n;
                mergePanelItem = new MergePanelItem(mergeResultItem.getLeftVersion(), mergeResultItem.getRightVersion(), mergeResultItem.getLineCount(), true, MergePanelItem.Type.CONFLICT, originalMergePanelItem, originalMergePanelItem2);
                this.mergePanel.addMergeItem(mergePanelItem);
                this.mergeOverview.addInterval(mergeResultItem.getLineCount(), 6);
            } else if (mergeResultItem.getType() == MergeResultItem.Type.WARNING_DELETE) {
                ++n2;
                boolean bl = mergeResultItem.getDefaultVersion() == MergeResultItem.DefaultVersion.LEFT;
                mergePanelItem = new MergePanelItem(mergeResultItem.getLeftVersion(), mergeResultItem.getRightVersion(), mergeResultItem.getLineCount(), bl, MergePanelItem.Type.WARNING_DELETE, originalMergePanelItem, originalMergePanelItem2);
                this.mergePanel.addMergeItem(mergePanelItem);
                this.mergeOverview.addInterval(mergeResultItem.getLineCount(), 5);
            } else if (mergeResultItem.getType() == MergeResultItem.Type.WARNING_ORDER) {
                ++n2;
                mergePanelItem = new MergePanelItem(mergeResultItem.getLeftVersion(), mergeResultItem.getRightVersion(), mergeResultItem.getLineCount(), true, MergePanelItem.Type.WARNING_ORDER, originalMergePanelItem, originalMergePanelItem2);
                this.mergePanel.addMergeItem(mergePanelItem);
                this.mergeOverview.addInterval(mergeResultItem.getLineCount(), 4);
            }
            final MergePanelItem mergePanelItem2 = mergePanelItem;
            if (mergePanelItem2 != null) {
                mergePanelItem.getViewPort().addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        Point point = mergePanelItem2.getViewPort().getViewPosition();
                        MergePanel.this.mergeHorScrollBar.setValue(point.x);
                    }
                });
            }
            this.originalLeft.addMergeItem(originalMergePanelItem);
            this.originalRight.addMergeItem(originalMergePanelItem2);
        }
        Object object = ResourceManager.getString((Object)ResourceKeyDiff.MERGE_RESULT) + " ";
        if (n > 0) {
            object = (String)object + ResourceManager.getString((Object)ResourceKeyDiff.CONFLICTS, n);
        }
        if (n2 > 0) {
            object = (String)object + ResourceManager.getString((Object)ResourceKeyDiff.WARNINGS, n2);
        }
        if (n == 0 && n2 == 0) {
            object = (String)object + ResourceManager.getString((Object)ResourceKeyDiff.NO_CONFLICT);
        }
        this.commentLabel.setText((String)object);
        this.onPanelResized();
        this.mergePanel.setItemsBounds();
        this.originalLeft.setItemsBounds();
        this.originalRight.setItemsBounds();
        this.repaint();
    }
}

