% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{endmembers}
\alias{endmembers}
\title{Petrographic end-member compositions}
\description{
A compositional dataset comprising the mineralogical compositions
of the following end-members: \code{undissected_magmatic_arc},
\code{dissected_magmatic_arc}, \code{ophiolite},
\code{recycled_clastic},
\code{undissected_continental_block},
\code{transitional_continental_block},
\code{dissected_continental_block},
\code{subcreted_axial_belt} and
\code{subducted_axial_belt}
}
\examples{
data(endmembers,densities)
ophiolite <- subset(endmembers,select="ophiolite")
plot(minsorting(ophiolite,densities,by=0.05))
}
\author{
Alberto Resentini and Pieter Vermeesch
}
\references{
Resentini, A, Malusa M G and Garzanti, E. "MinSORTING:
An Excel worksheet for modelling mineral grain-size distribution in
sediments, with application to detrital geochronology and
provenance studies." Computers & Geosciences 59 (2013): 90-97.

Garzanti, E, Ando, S and Vezzoli, G. "Settling
equivalence of detrital minerals and grain-size dependence of
sediment composition." Earth and Planetary Science Letters 273.1
(2008): 138-151.
}
\seealso{
minsorting
}

