#' library(provenance)
#'
#' \code{provenance} provides statistical tools to interpret large
#' amounts of distributional (single grain analyses) and compositional
#' (mineralogical and bulk chemical) data from the command line, or
#' using a menu-based user interface.
#'
#' A list of documented functions may be viewed by typing
#' \code{help(package='provenance')}.  Detailed instructions are
#' provided at \url{https://www.ucl.ac.uk/~ucfbpve/provenance/} and in
#' the Sedimentary Geology paper by Vermeesch, Resentini and Garzanti
#' (2016).
#' @references Vermeesch, P., Resentini, A. and Garzanti, E., 2016, An
#'     R package for statistical provenance analysis, Sedimentary
#'     Geology, 336, 14-25.
#' @name provenance
#' @docType package
#' @aliases provenance-package
"_PACKAGE"
#> [1] "_PACKAGE"
