.makePrecursorID <- function(peprot, sep="|"){
    tmp = peprot[,c("peptideModSeq","precursorCharge")]
    tmp = apply(tmp,2,as.character)
    apply(tmp, 1, paste, collapse = sep)
}
#' given table of peptide protein assigments generate matrix
#'
#' @param data generated by annotatePeptides
#' @param weighting weight type to use. Options are "one" , "AA" - amino acids, "coverage" - coverage , "inverse" - inverse peptide frequencies
#' @param sep separator for precursor (rownames)
#' @return sparse matrix
#' @export
#' @examples
#' library(prozor)
#' data(protpepmetashort)
#' library(Matrix)
#' colnames(protpepmetashort)
#' head(protpepmetashort)
#' dim(protpepmetashort)
#' count = prepareMatrix( protpepmetashort)
#' inverse = prepareMatrix( protpepmetashort, weight = "inverse")
#' aa = prepareMatrix(protpepmetashort, weight = "AA")
#' #xx = prepareMatrix(protpepmetashort, weight = "coverage")
#' image( as.matrix(count) )
#'
#' corProt = cor( as.matrix(count) )
#' par(mfrow =c(1,2))
#' image(corProt)
#'
#' #penalise peptides matching many proteins
#' corProtn = cor( as.matrix(aa) )
#' image(corProtn)
#'
prepareMatrix <- function(data, weighting = "one", sep="|" ) {
    fprots = as.factor( data[,"proteinID"] )
    prots = as.integer( fprots )
    fpeps = as.factor( .makePrecursorID(data, sep = sep) )
    peps = as.integer(fpeps)
    if(weighting=="one"){
        pepProt =sparseMatrix(peps , prots, x = 1 )
    } else if(weighting == "AA") {
        pepProt = sparseMatrix(peps, prots, x = data[,"lengthPeptide"] )
    } else if(weighting == "coverage"){
        pepProt = sparseMatrix(peps, prots, x = data[,"lengthPeptide"] / data[,"lengthProtein"] )
    } else if(weighting == "inverse"){
        pepProt = sparseMatrix(peps, prots, x = 1 )
        nrPeps = rowSums(pepProt)
        pepProt <- sweep(pepProt, 1 , nrPeps, "/" )
    } else {
        stopifnot(FALSE)
    }
    colnames(pepProt) <- levels(fprots)
    rownames(pepProt) <- levels(fpeps)
    dim(pepProt)
    return(pepProt)
}

