##' plotSpwPSheatmap
##'
##'
##' @title Plot subpathway phenotypic significant heat map
##' @description Visualize subpathway activity significant heat map between phenotypes
##'
##' @param inputdata A list of result data generated by function `SubSEA` or `DCSA`.
##' @param spwid The subpathway id which the user wants to plot.
##' @details
##' A heat map of the significance P-value of the activity of the subpathway between the phenotypes.
##' The rows and columns of the heat map are sample phenotype labels. The values shown in the heat map are the T-test
##' P values between the activity of the subpathway corresponding to the two phenotypes. The lower the number in the cells
##' in the heat map, the greater the difference in the activity of the subpathways between the two phenotypes.
##' @return a plot

##' @author Xudong Han,
##' Junwei Han,
##' Qingfei Kong
##' @examples
##' # get the Subspwresult which is the result of SubSEA method.
##' Subspwresult<-get("Subspwresult")
##' # plot significant heat map between the activity of the subpathway in each subtype of breast cancer.
##' plotSpwPSheatmap(Subspwresult,spwid="00120_9")
##' # get the DCspwresult which is the result of DCSA method.
##' DCspwresult<-get("DCspwresult")
##' # plot significant heat map between the activity of the subpathway in each stage of breast cancer.
##' plotSpwPSheatmap(DCspwresult,spwid="00982_2")
##' @importFrom pheatmap pheatmap
##' @importFrom stats t.test
##' @export
plotSpwPSheatmap<-function(inputdata,spwid=""){
  spw_value<-inputdata$spwmatrix[spwid,]
  sample_label<-colnames(inputdata$spwmatrix)
  phen_label<-names(table(sample_label))
  phen_N<-length(phen_label)

  rtmatrix<-matrix(0,ncol = phen_N,nrow = phen_N)
  for(i in 1:phen_N){
    phen_value1<-spw_value[which(names(spw_value)==phen_label[i])]
    for(j in 1:phen_N){
      phen_value2<-spw_value[which(names(spw_value)==phen_label[j])]
      rtmatrix[j,i]<-t.test(phen_value1,phen_value2)$p.value
    }
  }
  colnames(rtmatrix)<-phen_label
  row.names(rtmatrix)<-phen_label
  pheatmap(rtmatrix,cluster_rows=F,cluster_cols=F,display_numbers = TRUE,number_format='%.1e')
}
