% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSubSEScurve.R
\name{plotSubSEScurve}
\alias{plotSubSEScurve}
\title{Plot subtype set sample enrichment score curve graph}
\usage{
plotSubSEScurve(inputdata, spwid = "", phenotype = "all")
}
\arguments{
\item{inputdata}{A list of result data generated by function `SubSEA` or `DCSA`.}

\item{spwid}{The subpathway id which the user wants to plot.}

\item{phenotype}{The `phenotype`` specifies which phenotypic phenotype set enrichment curve is drawn for subpathway.
When `phenotype="all"` (default), the phenotype set enrichment score curve graph of subpathway under all phenotypes is drawn.}
}
\value{
a plot

an enrichment score curve graph
}
\description{
Draw a sample enrichment score curve graph of a single or all subtypes.
}
\details{
plotSubSEScurve


Plot a phenotype set enrichment score curve graph of a subpathway under all phenotypes or specified phenotype, including the
location of the maximum enrichment score (ES) and the leading-edge subset. This function can only be used for the results of
the `SubSEA` function.
}
\examples{
# get the results of the SubSEA function for breast cancer subtypes.
Subspwresult<-get("Subspwresult")
# plot enrichment score curve of the subpathway 00120_9 in all breast cancer subtypes.
plotSubSEScurve(Subspwresult,spwid="00120_9",phenotype="all")
# plot enrichment score curve of the subpathway 00120_9 in the basal breast cancer subtypes.
plotSubSEScurve(Subspwresult,spwid="00120_9",phenotype="Basal")
}
\author{
Xudong Han,
Junwei Han,
Qingfei Kong
}
