% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\docType{class}
\name{DataSimObject-class}
\alias{DataSimObject-class}
\alias{.datasim_object}
\title{Data Simulation Object Class}
\value{
A \code{DataSimObject}
}
\description{
Data Simulation Object Class
}
\section{Slots}{

\describe{
\item{\code{baseline}}{\code{BaselineObject} from \link{create_baseline_object}}

\item{\code{coefficients}}{Named \code{numeric} vector of \code{beta} coefficients for survival model. See \code{beta} at
\code{?simsurv::simsurv}}

\item{\code{treatment_hr}}{\code{numeric} treatment effect as a hazard ration. \code{log(treatment_hr)} is included in \code{beta} with
\code{coefficients} and \code{log(drift_hr)}. This default is overridden by \link[=generate,DataSimObject-method]{generate}
arguments}

\item{\code{drift_hr}}{\code{numeric} hazard ratio between internal and external arms. Included as \code{log(drift_hr)}.}

\item{\code{fixed_external_data}}{\code{data.frame} for external data. Currently unused.}

\item{\code{event_dist}}{\code{DataSimEvent} parameters for outcome distribution from \code{\link[=create_event_dist]{create_event_dist()}}}

\item{\code{enrollment}}{\code{DataSimEnrollment} object.}

\item{\code{cut_off}}{\code{DataSimCutOff}}
}}

