% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_borrowing_list.R
\name{sim_borrowing_list}
\alias{sim_borrowing_list}
\title{Input borrowing details for a simulation study}
\usage{
sim_borrowing_list(borrowing_list)
}
\arguments{
\item{borrowing_list}{named list of objects of class \code{Borrowing} created
by \code{borrowing_full()}, \code{borrowing_none()}, or \code{borrowing_hierarchical_commensurate()}.}
}
\value{
Object of class \code{\link[=SimBorrowingList-class]{SimBorrowingList}}.
}
\description{
A function for defining which borrowing scenarios should be evaluated as
part of a simulation study.
}
\examples{

borrow_scenarios <- sim_borrowing_list(
  list(
    "No borrowing" = borrowing_none("ext"),
    "Full borrowing" = borrowing_full("ext"),
    "BDB, uninformative prior" = borrowing_hierarchical_commensurate(
      "ext",
      prior_gamma(0.001, 0.001)
    ),
    "BDB, informative prior" = borrowing_hierarchical_commensurate(
      "ext",
      prior_gamma(1, 0.001)
    )
  )
)

}
\seealso{
Other simulation classes: 
\code{\link{sim_covariate_list}()},
\code{\link{sim_data_list}()},
\code{\link{sim_outcome_list}()},
\code{\link{sim_treatment_list}()}
}
\concept{simulation classes}
