% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_gamma.R
\docType{class}
\name{PriorGamma-class}
\alias{PriorGamma-class}
\alias{.prior_gamma}
\title{\code{PriorGamma} Class}
\description{
A class for defining gamma priors to be translated to Stan code.
Objects of class \code{PriorGamma} should not be created directly but by
the constructor \code{\link[=prior_gamma]{prior_gamma()}}.
}
\section{Slots}{

\describe{
\item{\code{stan_code}}{character. Stan implementation of the prior, with
placeholders for gamma stan function parameters surrounded with
\verb{\{\{} and \verb{\}\}} to be replaced with \code{\link[glue:glue]{glue::glue()}}.}

\item{\code{n_param}}{integer. Number of prior parameters (2).}

\item{\code{constraint}}{character. Support of prior distribution,
\code{"<lower=0>"}.}

\item{\code{alpha}}{numeric. Shape (>0).}

\item{\code{beta}}{numeric. Inverse scale (>=0).}
}}

\seealso{
Other prior classes: 
\code{\link{Prior-class}},
\code{\link{PriorBernoulli-class}},
\code{\link{PriorBeta-class}},
\code{\link{PriorCauchy-class}},
\code{\link{PriorExponential-class}},
\code{\link{PriorHalfCauchy-class}},
\code{\link{PriorHalfNormal-class}},
\code{\link{PriorNormal-class}},
\code{\link{PriorPoisson-class}},
\code{\link{UniformPrior-class}}
}
\concept{prior classes}
