% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_data_matrix.R
\name{create_data_matrix}
\alias{create_data_matrix}
\title{Create Data Matrix}
\usage{
create_data_matrix(
  data,
  outcome,
  trt_flag_col,
  ext_flag_col,
  covariates = NULL,
  weight_var = NULL
)
}
\arguments{
\item{data}{data.frame. Data containing all variables}

\item{outcome}{character. The outcome variable for binary outcomes or the time and censoring variables.}

\item{trt_flag_col}{character. The treatment indicator variable.}

\item{ext_flag_col}{character. The external cohort indicator.}

\item{covariates}{character or formula. The covariates for model adjustment.}

\item{weight_var}{character. An optional weight variable.}
}
\value{
Invisibly returns a \code{matrix} containing all variables to pass to \code{\link[=create_analysis_obj]{create_analysis_obj()}}.
Prints names of covariates columns to use with \code{\link[=add_covariates]{add_covariates()}}.
}
\description{
Creates a matrix suitable for \code{\link[=create_analysis_obj]{create_analysis_obj()}}. Creates dummy variables for factors and
allows transformations of covariates specified with a formula.
}
\examples{
dat <- survival::diabetic
dat$ext <- dat$trt == 0 & dat$id > 1000
data_mat <- create_data_matrix(
  dat,
  outcome = c("time", "status"),
  trt_flag_col = "trt",
  ext_flag_col = "ext",
  covariates = ~ age + laser + log(risk)
)
data_mat
}
