% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_bin_logistic.R
\name{outcome_bin_logistic}
\alias{outcome_bin_logistic}
\title{Bernoulli distribution with logit parametrization}
\usage{
outcome_bin_logistic(binary_var, baseline_prior, weight_var = "")
}
\arguments{
\item{binary_var}{character. Name of binary (1/0 or TRUE/FALSE) outcome variable in the
model matrix}

\item{baseline_prior}{\code{Prior}. Object of class \code{Prior}
specifying prior distribution for the baseline outcome.
See \code{Details} for more information.}

\item{weight_var}{character. Optional name of variable in model matrix for weighting the log likelihood.}
}
\value{
Object of class \code{\link[=OutcomeBinaryLogistic-class]{OutcomeBinaryLogistic}}.
}
\description{
Bernoulli distribution with logit parametrization
}
\details{
\subsection{Baseline Prior}{

The \code{baseline_prior} argument specifies the prior distribution for the
baseline log odds. The interpretation of the \code{baseline_prior} differs
slightly between borrowing methods selected.
\itemize{
\item \emph{Dynamic borrowing using \code{borrowing_hierarchical_commensurate()}}: the \code{baseline_prior} for Bayesian Dynamic Borrowing refers
to the log odds of the external control arm.
\item \emph{Full borrowing} or \emph{No borrowing} using \code{borrowing_full()} or \code{borrowing_none()}: the \code{baseline_prior} for
these borrowing methods refers to the log odds for the
internal control arm.
}
}
}
\examples{
lg <- outcome_bin_logistic(
  binary_var = "response",
  baseline_prior = prior_normal(0, 1000)
)
}
\seealso{
Other outcome models: 
\code{\link{outcome_cont_normal}()},
\code{\link{outcome_surv_exponential}()},
\code{\link{outcome_surv_weibull_ph}()}
}
\concept{outcome models}
