% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbma.R
\name{sbma}
\alias{sbma}
\alias{sbma.LHS}
\alias{sbma.default}
\title{Calculates the Symetrized Blest Measure of Agreement between two samples}
\usage{
sbma(sample1, sample2, absolute = TRUE, ...)

\method{sbma}{default}(sample1, sample2, absolute = TRUE, ...)

\method{sbma}{LHS}(sample1, sample2, absolute, ...)
}
\arguments{
\item{sample1}{The first vector or LHS object to be compared.}

\item{sample2}{The second vector or LHS object to be compared.}

\item{absolute}{Logical. Should the absolute values of sample1 and sample2 be used 
in the calculation?}

\item{\dots}{Additional arguments.}
}
\description{
The Symetrized Blest Measure of Agreement is an alternative measure of
rank correlation (similar to Kendall's Tau and Spearman's Rho). This correlation
measure is more sensitive to changes in the order of the first elements of a vector 
(see examples).
}
\details{
This	function calculates the SBMA between two samples or two \code{\link{LHS}} objects.
In the second case, what is compared is the values of the "prcc" component of
each Hypercube.
}
\examples{
# SBMA is only affected by the rank of the values inside each vector
sbma(c(1,2,3,4), c(2,3,4,5))
# Changes in the first positions: high impact on the SBMA
sbma(c(1,2,3,4), c(2,1,3,4))
cor(c(1,2,3,4), c(2,1,3,4), method="spearman")
# Changes in the last positions: low impact on the SBMA
sbma(c(1,2,3,4), c(1,2,4,3))
cor(c(1,2,3,4), c(1,2,4,3), method="spearman")
}
\references{
Maturi, T.A. and Elsayigh, A. 2010. A comparison of correlation coefficients 
 via a three-step bootstrap approach. \emph{Journal of Mathematics Research} 2(2): 3-10.
}

