% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{pspline.sample.timeseries}
\alias{pspline.sample.timeseries}
\title{Runs simulations on an outbreak GAM/GAMM for the purpose of estimating time series outbreak outcomes, and
returns estimated time series outcomes for each simulation.}
\usage{
pspline.sample.timeseries(model, predictors, outcome, samples = 100)
}
\arguments{
\item{model}{model returned by \code{\link[mgcv]{gam}} or \code{\link[mgcv]{gamm}}}

\item{outcome}{time series outcome generator function; see \code{\link{pspline.estimate.timeseries}} for more info}

\item{samples}{number of simulations to run}

\item{time}{time values at which the model will be evaluated during simulation}
}
\value{
matrix with one row for each simulation; each row contains the
time series calculated by \code{outcome} for the corresponding simulation run
}
\description{
This is mainly used internally by \code{pspline.estimate.timeseries}, but
it's useful if you want to calculate summary statistics of simulation results other
than the ones returned by \code{pspline.estimate.timeseries}.
}
\keyword{internal}
