% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediation_summary.R
\name{mediation_summary}
\alias{mediation_summary}
\title{Mediation Analysis}
\usage{
mediation_summary(
  data,
  response_variable,
  mediator,
  predictor_variable,
  control_variable = NULL,
  group = NULL,
  standardize = TRUE,
  digits = 3,
  quite = FALSE,
  streamline = FALSE,
  return_result = FALSE
)
}
\arguments{
\item{data}{data frame}

\item{response_variable}{response variable. Support \code{dplyr::select()} syntax.}

\item{mediator}{mediator. Support \code{dplyr::select()} syntax.}

\item{predictor_variable}{predictor variable. Support \code{dplyr::select()} syntax.}

\item{control_variable}{control variables. Support \code{dplyr::select()} syntax.}

\item{group}{nesting variable for multilevel mediation. Not confident about the implementation method. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}

\item{standardize}{standardized coefficients. Default is \code{TRUE}}

\item{digits}{number of digits to round to}

\item{quite}{suppress printing output}

\item{streamline}{print streamlined output}

\item{return_result}{If it is set to \code{TRUE}, it will return the \code{lavaan} object}
}
\value{
an object from \code{lavaan}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} \cr
It currently only support simple mediation analysis.
In the backend, it called the \code{lavaan::sem()} model. I am trying to implement multilevel mediation in \code{lavaan}.
In the future, I will try supporting moderated mediation (through \code{lavaan} or \code{mediation}) and mediation with latent variable (through \code{lavaan}).
}
\examples{
mediation_summary(
  data = lmerTest::carrots,
  response_variable = Preference,
  mediator = Sweetness,
  predictor_variable = Crisp
)
}
