% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{aovTable}
\alias{aovTable}
\title{aovTable}
\usage{
aovTable(
  aovObj,
  effectSize = "pes",
  sphericityCorrections = TRUE,
  sphericityCorrectionType = "GG",
  removeSumSquares = TRUE,
  roundDigits = TRUE,
  numDigits = 2
)
}
\arguments{
\item{aovObj}{Output from aov or ezANOVA (NB. ezANOVA must be called with detailed = TRUE)}

\item{effectSize}{Effect size (pes vs. ges)}

\item{sphericityCorrections}{TRUE/FALSE (ezANOVA)}

\item{sphericityCorrectionType}{"GG" (default) vs. "HF" (ezANOVA)}

\item{removeSumSquares}{TRUE/FALSE Remove SSn/SSd columns from the ANOVA table}

\item{roundDigits}{TRUE/FALSE Round numerical values to numDigits}

\item{numDigits}{The number of digits to round to if roundDigits = TRUE}
}
\value{
list
}
\description{
Adjust ezANOVA table output. Options include calculation of alternative
effect sizes (eta squared, partial eta squared), the calculation of marginal
means and formatting options for the ANOVA table (e.g., detailed, rounding).
}
\examples{
# Example 1:
# create dataframe with 2(Comp: comp vs. incomp) and 2(Side: left vs. right) factors/levels
dat <- createDF(nVP = 20, nTrl = 1,
                design = list("Comp" = c("comp", "incomp"),
                              "Side" = c("left", "right")))

dat <- addDataDF(dat,
                 RT = list("Comp:Side_comp:left"    = c(500, 150, 150),
                           "Comp:Side_comp:right"   = c(500, 150, 150),
                           "Comp:Side_incomp:left"  = c(500, 150, 150),
                           "Comp:Side_incomp:right" = c(500, 150, 150)))

aovRT <- aov(RT ~ Comp*Side + Error(VP/(Comp*Side)), dat)
aovRT <- aovTable(aovRT)

# or using ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp, Side),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)

}
