% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{metabulate}
\alias{metabulate}
\title{Write a summary table of meta-analytic results}
\usage{
metabulate(ma_obj, file = NULL, output_dir = getwd(),
  output_format = c("word", "html", "pdf", "odt", "text", "rmd"),
  show_msd = TRUE, show_conf = TRUE, show_cred = TRUE, show_se = FALSE,
  show_var = FALSE, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ma_method = "ad", correction_type = "ts",
  collapse_construct_labels = TRUE, bold_headers = TRUE, digits = 2L,
  decimal.mark = getOption("OutDec"), leading0 = "conditional",
  drop0integer = FALSE, neg.sign = "minus", pos.sign = "figure",
  big.mark = "thinspace", big.interval = 3L, small.mark = "thinspace",
  small.interval = 3L, conf_format = "parentheses",
  cred_format = "parentheses", symbol_es = "ES",
  caption = "Results of meta-analyses", header = NULL, verbose = FALSE,
  unicode = NULL, bib = NULL, title.bib = NULL, style = "apa",
  additional_citekeys = NULL, save_build_files = FALSE, ...)
}
\arguments{
\item{ma_obj}{A psychmeta meta-analysis object.}

\item{file}{The filename (optionally with a subfolder path) for the output file. If \code{NULL}, the function will output directly to the R console (also useful if you want to include psychmeta results in a larger RMarkdown document).}

\item{output_dir}{The filepath for the output directory/folder. Defaults to the current working directory.}

\item{output_format}{The format of the output tables. Available options are Word (default), HTML, PDF (requires LaTeX and the \code{unicode-math} LaTeX package to be installed), ODT, rmd (Rmarkdown), and text (plain text). You can also specify the full name of another RMarkdown \code{\link[rmarkdown]{output_format}}.}

\item{show_msd}{Logical. Should means and standard deviations of effect sizes be shown (default \code{TRUE})}

\item{show_conf}{Logical. Should confidence intervals be shown (default: \code{TRUE})?}

\item{show_cred}{Logical. Should credibility intervals be shown (default: \code{TRUE})?}

\item{show_se}{Logical Should standard errors be shown (default: \code{FALSE})?}

\item{show_var}{Logical. Should variances be shown (default: \code{FALSE})?}

\item{analyses}{Which analyses to extract references for? See \code{\link{filter_ma}} for details.}

\item{match}{Match \code{all} or \code{any} of the filter criteria? See \code{\link{filter_ma}} for details.}

\item{case_sensitive}{Logical scalar that determines whether character values supplied in \code{analyses} should be treated as case sensitive (\code{TRUE}, default) or not (\code{FALSE}).}

\item{ma_method}{Meta-analytic methods to be included. Valid options are: \code{"ad"}, \code{"ic"}, and \code{"bb"}. Multiple methods are permitted. By default, results are given for one method with order of priority: 1. \code{"ad"}, 2. \code{"ic"}, 3. \code{"bb"}.}

\item{correction_type}{Type of meta-analytic corrections to be incldued. Valid options are: "ts" (default), "vgx", and "vgy". Multiple options are permitted.}

\item{collapse_construct_labels}{Should the construct labels for construct pairs with multiple rows of results be simplified so that only the first occurence of each set of construct names is shown (\code{TRUE}; default) or should construct labels be shown for each row of the table (\code{FALSE}).}

\item{bold_headers}{Logical. Should column headers be bolded (default: \code{TRUE})?}

\item{digits}{The number of decimal digits desired (used strictly; default: 2)}

\item{decimal.mark}{The character to use for the decimal point (defaults to locale default: \code{getOption("OutDec")})}

\item{leading0}{How to print leading zeros on decimals. See \code{\link{format_num}} for details.}

\item{drop0integer}{Logical. Should trailing decimal zeros be dropped for integers?}

\item{neg.sign}{Character to use as negative sign. See \code{\link{format_num}} for details.}

\item{pos.sign}{Character to use as positive sign. See \code{\link{format_num}} for details.}

\item{big.mark}{Character to separate groups of large digits. See \code{\link{format_num}} for details.}

\item{big.interval}{See \code{big.mark} above; defaults to 3.}

\item{small.mark}{Character to sparate groups of decimal digits. See \code{\link{format_num}} for details.}

\item{small.interval}{See \code{small.mark} above; defaults to 3.}

\item{conf_format}{How should confidence intervals be formatted? Options are:
\itemize{
\item{\code{parentheses}}{: Bounds are enclosed in parentheses and separated by a comma: (LO, UP).}
\item{\code{brackets}}{: Bounds are enclosed in square brackets and separated by a comma: [LO, UP].}
\item{\code{columns}}{: Bounds are shown in individual columns.}
}}

\item{cred_format}{How should credility intervals be formatted? Options are the same as for \code{conf_format} above.}

\item{symbol_es}{For meta-analyses of generic (non-r, non-d) effect sizes, the symbol used for the effect sizes (default: \code{symbol_es = "ES"}).}

\item{caption}{Caption to print before tables. Either a character scalar or a named character vector with names corresponding to combinations of \code{ma_method} and \code{correction_type} (i.e., \code{bb}, \code{ic_ts}, \code{ad_vgx}, etc.).}

\item{header}{A list of YAML header parameters to pass to \code{link[rmarkdown]{render}}.}

\item{verbose}{Logical. Should detailed SD and variance components be shown (default: \code{FALSE})?}

\item{unicode}{Logical. If \code{output_format} is "text", should UTF-8 characters be used (defaults to system default).}

\item{bib}{A BibTeX file containing the citekeys for the meta-analyses. If provided and file is not \code{NULL}, a bibliography will be included with the meta-analysis table. See \code{\link{generate_bib}} for additional arguments controlling the bibliography.}

\item{title.bib}{The title to give to the bibliography (see \code{bib} above). If \code{NULL}, defaults to "Sources Contributing to Meta-Analyses"}

\item{style}{What style should the bibliography (see \code{bib} above) be formatted in? Can be a file path or URL for a \url{https://github.com/citation-style-language/styles}{CSL citation style} or the style ID for any style available from the \url{https://zotero.org/styles}{Zotero Style Repository}). Defaults to APA style. (Retrieving a style by ID requires an internet connection. If unavailable, references will be rendered in Chicago style.).}

\item{additional_citekeys}{Additional citekeys to include in the reference list (see \code{bib} above).}

\item{save_build_files}{Should the RMarkdown and BibLaTeX (if any) files used to generate the output be saved (default: \code{FALSE})?}

\item{...}{Additional arguments to pass to \code{\link[rmarkdown]{render}}.}
}
\value{
A list of meta-analysis results \code{\link[tibble]{tibble}}s with "caption" and "footnote" attributes.

If \code{file} is specified, formatted tables and bibliographies are exported in the requested \code{output_format}.

Formatted tables of meta-analytic output.
}
\description{
Write a summary table of meta-analytic results
}
\examples{
\dontrun{
## Create a results table for meta-analysis of correlations and output to Word:
ma_r_obj <- ma_r(ma_method = "ic", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
                 construct_x = x_name, construct_y = y_name,
                 moderators = moderator, data = data_r_meas_multi)
metabulate(ma_obj = ma_r_obj, file = "meta tables correlations",
           output_format = "word", output_dir = tempdir())

## Output to PDF:
metabulate(ma_obj = ma_r_obj, file = "meta tables correlations",
           output_format = "pdf", output_dir = tempdir())

## Output to ODT (LibreOffice):
metabulate(ma_obj = ma_r_obj, file = "meta tables correlations",
           output_format = "odt", output_dir = tempdir())


## To produce Markdown tables to include inline in an RMarkdown report,
## leave file == NULL and output_format to anything but "text":
ma_table <- metabulate(ma_obj = ma_r_obj, file = NULL, output_format = "rmd")

## Use the metabulate_rmd_helper() function to ensure all symbols render properly:
metabulate_rmd_helper()

## Then, add the formatted table to your document using your preferred table
## formatting functions:

#### Using just the \\link{knitr} package:
knitr::kable(ma_table[[1]], caption = attr(ma_table[[1]], "caption"))
cat("\\n", attr(ma_table[[1]], "footnote"))

#### Using \\link{knitr} plus the \\link{kableExtra} package:
knitr::kable(ma_table[[1]], "latex", booktabs = TRUE,
                  caption = attr(ma_table[[1]], "caption")) \%>\%
       kableExtra::kable_styling(latex_options = c("striped", "hold_position")) \%>\%
       kableExtra::footnote(general = attr(ma_table[[1]], "footnote")

# !!! Note: On Windows, R currently can only handle Unicode characters if kables
# are printed at top-level (e.g., in an if() statement, in a for() loop,
# or in lapply() or map() ). To correctly print Unicode metabulate tables, call
# kable() as a top-level function (as above).


## Create output table for meta-analysis of d values:
ma_d_obj <- ma_d(ma_method = "ic", d = d, n1 = n1, n2 = n2, ryy = ryyi,
                 construct_y = construct, data = data_d_meas_multi)
ma_d_obj <- ma_d_ad(ma_obj = ma_d_obj, correct_rr_g = FALSE, correct_rr_y = FALSE)
metabulate(ma_obj = ma_d_obj, file = "meta tables d values", output_dir = tempdir())

## Create output table for meta-analysis of generic effect sizes:
dat <- data.frame(es = data_r_meas_multi$rxyi,
                  n = data_r_meas_multi$n,
                  var_e = (1 - data_r_meas_multi$rxyi^2)^2 / (data_r_meas_multi$n - 1))
ma_obj <- ma_generic(es = es, n = n, var_e = var_e, data = dat)
metabulate(ma_obj = ma_obj, file = "meta tables generic es", output_dir = tempdir())
}
}
\seealso{
Other output functions: \code{\link{generate_bib}},
  \code{\link{metabulate_rmd_helper}}
}
