% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_es.R
\name{convert_es}
\alias{convert_es}
\title{Convert effect sizes}
\usage{
convert_es(
  es,
  input_es = c("r", "d", "delta", "g", "t", "p.t", "F", "p.F", "chisq", "p.chisq",
    "or", "lor", "Fisherz", "A", "auc", "cles"),
  output_es = c("r", "d", "A", "auc", "cles"),
  n1 = NULL,
  n2 = NULL,
  df1 = NULL,
  df2 = NULL,
  sd1 = NULL,
  sd2 = NULL,
  tails = 2
)
}
\arguments{
\item{es}{Vector of effect sizes to convert.}

\item{input_es}{Scalar. Metric of input effect sizes. Currently supports correlations, Cohen's \emph{d}, independent samples \emph{t} values (or their \emph{p} values), two-group one-way ANOVA \emph{F} values (or their \emph{p} values), 1df \eqn{\chi^{2}}{\chi-squared} values (or their \emph{p} values), odds ratios, log odds ratios, Fisher \emph{z}, and the common language effect size (CLES, A, AUC).}

\item{output_es}{Scalar. Metric of output effect sizes. Currently supports correlations, Cohen's \emph{d} values, and common language effect sizes (CLES, A, AUC).}

\item{n1}{Vector of total sample sizes or sample sizes of group 1 of the two groups being contrasted.}

\item{n2}{Vector of sample sizes of group 2 of the two groups being contrasted.}

\item{df1}{Vector of input test statistic degrees of freedom (for \emph{t} and \eqn{\chi^{2}}{\chi-squared}) or between-groups degree of freedom (for \emph{F}).}

\item{df2}{Vector of input test statistic within-group degrees of freedom (for \emph{F}).}

\item{sd1}{Vector of pooled (within-group) standard deviations or standard deviations of group 1 of the two groups being contrasted.}

\item{sd2}{Vector of standard deviations of group 2 of the two groups being contrasted.}

\item{tails}{Vector of the tails for \emph{p} values when \code{input_es = "p.t"}. Can be \code{2} (default) or \code{1}.}
}
\value{
A data frame of class \code{es} with variables:
\item{\code{r}, \code{d}, \code{A}}{The converted effect sizes}
\item{\code{n_effective}}{The effective total sample size}
\item{\code{n}}{The total number of cases (original sample size)}
\item{\code{n1}, \code{n2}}{If applicable, subgroup sample sizes}
\item{\code{var_e}}{The estimated sampling error variance}
}
\description{
This function converts a variety of effect sizes to correlations, Cohen's \emph{d} values, or common language effect sizes, and calculates sampling error variances and effective sample sizes.
}
\examples{
convert_es(es = 1,  input_es="d", output_es="r", n1=100)
convert_es(es = 1, input_es="d", output_es="r", n1=50, n2 = 50)
convert_es(es = .2, input_es="r", output_es="d",  n1=100, n2=150)
convert_es(es = -1.3, input_es="t", output_es="r", n1 = 100, n2 = 140)
convert_es(es = 10.3, input_es="F", output_es="d", n1 = 100, n2 = 150)
convert_es(es = 1.3, input_es="chisq", output_es="r", n1 = 100, n2 = 100)
convert_es(es = .021, input_es="p.chisq", output_es="d", n1 = 100, n2 = 100)
convert_es(es = 4.37, input_es="or", output_es="r", n1=100, n2=100)
convert_es(es = 4.37, input_es="or", output_es="d", n1=100, n2=100)
convert_es(es = 1.47, input_es="lor", output_es="r", n1=100, n2=100)
convert_es(es = 1.47, input_es="lor", output_es="d", n1=100, n2=100)
}
\references{
Chinn, S. (2000).
A simple method for converting an odds ratio to effect size for use in meta-analysis.
\emph{Statistics in Medicine, 19}(22), 3127–3131.
\doi{10.1002/1097-0258(20001130)19:22<3127::AID-SIM784>3.0.CO;2-M}

Lipsey, M. W., & Wilson, D. B. (2001). \emph{Practical meta-analysis}. SAGE Publications.

Ruscio, J. (2008).
A probability-based measure of effect size: Robustness to base rates and other factors.
\emph{Psychological Methods, 13}(1), 19–30. \doi{10.1037/1082-989X.13.1.19}

Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
SAGE Publications. \doi{10.4135/9781483398105}
}
