% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crawford.test.R
\name{crawford.test}
\alias{crawford.test}
\title{Crawford-Howell (1998) t-test for single-case analysis.}
\usage{
crawford.test(case, controls, verbose = T)
}
\arguments{
\item{case}{Single value (patient's score).}

\item{controls}{Vector of values (control's scores).}

\item{verbose}{True or False. Prints the interpretation text.}
}
\value{
Returns a data frame containing the t-value, degrees of freedom, and p-value. If significant, the case is different from the control group.
}
\description{
Neuropsychologists often need to compare a single case to a small control group. However, the standard two-sample t-test does not work because the case is only one observation. Crawford and Garthwaite (2012) demonstrate that the Crawford-Howell (1998) t-test is a better approach (in terms of controlling Type I error rate) than other commonly-used alternatives.
.
}
\examples{
library(psycho)

crawford.test(case = 10, controls = c(0, -2, 5, 2, 1, 3, -4, -2))
crawford.test(case = 7, controls = c(0, -2, 5, 2, 1, 3, -4, -2))

}
\author{
Dan Mirman, Dominique Makowski
}
