% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_factors.R
\name{n_factors}
\alias{n_factors}
\title{Find Optimal Factor Number.}
\usage{
n_factors(df, rotate = "varimax", fm = "minres", n = NULL)
}
\arguments{
\item{df}{A dataframe or correlation matrix}

\item{rotate}{What rotation to use c("none", "varimax", "oblimin","promax")}

\item{fm}{Factoring method: "pa" for Principal Axis Factor Analysis,
"minres" (default) for minimum residual (OLS) factoring, "mle" for
Maximum Likelihood FA and "pc" for Principal Components}

\item{n}{If correlation matrix is passed, the sample size.}
}
\value{
output
}
\description{
Find optimal components number using maximum method aggreement.
}
\examples{
df <- dplyr::select_if(attitude, is.numeric)
results <- psycho::n_factors(df)

summary(results)
plot(results)

# See details on methods
psycho::values(results)$methods
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
