% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetStandardAtmTemperature}
\alias{GetStandardAtmTemperature}
\title{Return standard atmosphere temperature, given the elevation (altitude).}
\usage{
GetStandardAtmTemperature(Altitude)
}
\arguments{
\item{Altitude}{A numeric vector of altitude in ft [IP] or m [SI]}
}
\value{
A numeric vector of standard atmosphere dry-bulb temperature in degreeF [IP] or degreeC [SI]
}
\description{
Return standard atmosphere temperature, given the elevation (altitude).
}
\examples{
SetUnitSystem("IP")
GetStandardAtmTemperature(seq(-500, 1000, 100))

SetUnitSystem("SI")
GetStandardAtmTemperature(seq(-500, 1000, 100))

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 4
}
