% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddG.R
\name{ddG.ptm}
\alias{ddG.ptm}
\title{PDB Model and Change in Stability of a Modified Protein}
\usage{
ddG.ptm(pdb, ch, pos, ptm, dir = 'f', pH = 7)
}
\arguments{
\item{pdb}{the 4-letter identifier of a PDB structure or the path to a PDB file.}

\item{ch}{a letter identifying the chain of interest.}

\item{pos}{the position, in the primary structure, of the residue to be modified.}

\item{ptm}{the post-translational modification to be considered. It should be one among: 'pSer', 'pThr', 'pTyr', 'MetO-Q', 'MetO-T'.}

\item{dir}{indicates the direction of the PTM reaction: either forward ('f'), or backward ('b').}

\item{pH}{a numeric value between 0 and 14.}
}
\value{
The function computes and returns the DDG (kcal/mol) for the requested modification, defined as DDG = DGmodified - DGunmodified, where DG is the Gibbs free energy for the folding of the protein from its unfolded state. Thus, a positive value means a destabilizing effect, and vice versa. A PDB model containing the modified target is saved in the current directory.
}
\description{
Builds a PDB model of the modified protein and computes the corresponding change in stability.
}
\details{
The current function uses FoldX to build the model of the modified protein. Currently, FoldX does not allow to change Met by MetO, so we use glutamine (Q) or threonine (T) to mimic MetO.
}
\examples{
\dontrun{ddG.ptm('./1u8f_Repair.pdb', 'O', pos = 246, ptm = 'pThr')}
}
\references{
Schymkowitz et al (2005) Nucl. Ac. Res. 33:W382-W388.
}
\seealso{
imutant(), foldx.mut(), ddG.profile()
}
\author{
Juan Carlos Aledo
}
