% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getseq.R
\name{id.features}
\alias{id.features}
\title{Features Related to the Protein Entry}
\usage{
id.features(id, features = "")
}
\arguments{
\item{id}{the UniProt identifier of the protein of interest.}

\item{features}{a string identifying the features (comma separated) to be recovered.}
}
\value{
Returns a named list with the requested features.
}
\description{
Obtains features related to the provided id.
}
\details{
By default the the function provides info regarding the following features: id, reviewed, entry name and organism. If wished, this list of features can be expanded using the argument 'features'. There is a larga list of features that can be retrieved. You can look up your relevant feature's name in the full list of UniProtKB found at https://www.uniprot.org/help/uniprotkb_column_names.
}
\examples{
\dontrun{id.features('P04406', features = 'ec,keywords,database(PDB)')}
}
\seealso{
species.mapping()
}
\author{
Juan Carlos Aledo
}
