% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptmScan.R
\name{p.scan}
\alias{p.scan}
\title{Scan a Protein in Search of  Phosphosites}
\usage{
p.scan(up_id, db = 'all')
}
\arguments{
\item{up_id}{a character string corresponding to the UniProt ID.}

\item{db}{the database where to search. It should be one among 'PSP', 'dbPTM','dbPAF', 'PhosPhAt', 'Phospho.ELM', 'all'.}
}
\value{
Returns a dataframe where each row corresponds to a phosphorylatable residue.
}
\description{
Scans the indicated protein in search of phosphosites.
}
\details{
If db = 'all' has been selected, it may happen that the same residue appears in several rows if it is present in different databases.
}
\examples{
\dontrun{p.scan('P01009', db = 'PSP')}
}
\references{
Hornbeck et al. Nucleic Acids Res. 2019 47:D433-D441, (PMID: 30445427).

Huang et al. Nucleic Acids Res. 2019 47:D298-D308, (PMID: 30418626).

Ullah et al. Sci. Rep. 2016 6:23534, (PMID: 27010073).

Durek et al. Nucleic Acids Res.2010 38:D828-D834, (PMID: 19880383).

Dinkel et al. Nucleic Acids Res. 2011 39:D261-D567 (PMID: 21062810).
}
\seealso{
meto.scan(), ac.scan(), me.scan(), ub.scan(), su.scan(), gl.scan(), sni.scan(), ni.scan(), ptm.scan(), reg.scan(), dis.scan()
}
\author{
Juan Carlos Aledo
}
