% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptmplot.R
\name{ptm.plot}
\alias{ptm.plot}
\title{Plot Values of a Property and PTM Sites Along the Protein Sequence}
\usage{
ptm.plot(up_id, pdb = "", property, ptm, window = 1, sdata = FALSE, ...)
}
\arguments{
\item{up_id}{a character string for the UniProt ID of the protein of interest.}

\item{pdb}{Optional argument to indicate the PDB and chain to be used (i.e. '1u8f.O'). If we leave this argument empty, the function will make the election for us whenever possible.}

\item{property}{a character string indicating the property of interest. It should be one of 'sasa', 'acc', 'dpx', 'eiip', 'volume', 'polarizability', 'avg.hyd', 'pi.hel', 'a.hel', 'b.sheet', 'B.factor', or 'own'.}

\item{ptm}{a character vector indicating the PTMs of interest. It should be among: 'ac' (acetylation), 'me' (methylation), 'meto' (sulfoxidation), 'p' (phosphorylation), 'ni' (nitration), 'su' (sumoylation) or 'ub' (ubiquitination), 'gl' (glycosylation), 'sni' (S-nitrosylation),'reg' (regulatory), 'dis' (disease).}

\item{window}{positive integer indicating the window size for smoothing with a sliding window average (default: 1, i.e. no smoothing).}

\item{sdata}{logical, if TRUE save a Rda file with the relevant data in the current directory.}

\item{...}{when the user want to use his/her own amino acid index, it can be passed as a named vector.}
}
\value{
This function returns either one or two plots related to the chosen property along the primary structure, as well as the computed data if sdata has been set to TRUE.
}
\description{
Represents the values of a property and show the PTM sites along a protein sequence.
}
\details{
If the property 'own' is selected, a named vector with the own index for the 20 amino acids should be passed as argument.
Currently the supported properties are:
\itemize{
\item sasa:  Solvent-accessible surface area (3D)
\item acc: Accessibility (3D)
\item dpx: Depth (3D)
\item volume: Normalized van der Waals volume (1D)
\item mutability: Relative mutability, Jones 1992, (1D)
\item helix: Average relative probability of helix, Kanehisa-Tsong 1980,(1D)
\item beta-sheet: Average relative probability of beta-sheet, Kanehisa-Tsong 1980, (1D)
\item pi-helix: Propensity of amino acids within pi-helices, Fodje-Al-Karadaghi 2002, (1D)
\item hydropathy: Hydropathy index, Kyte-Doolittle 1982, (1D)
\item avg.hyd: Normalized average hydrophobicity scales, Cid et al 1992, (1D)
\item hplc: Retention coefficient in HPLC at pH7.4, Meek 1980, (1D)
\item argos: Hydrophobicity index, Argos et al 1982, (1D)
\item eiip: Electron-ion interaction potential, Veljkovic et al 1985, (1D)
\item polarizability: Polarizability parameter, Charton-Charton 1982, (1D)
}
For 3D properties such as sasa, acc or dpx, for which different values can be obtained depending on the quaternary structure, we first compute the property values for each residue in the whole protein and plotted them against the residue position. Then, the value for this property is computed in the isolated chain (a single polypeptide chain) and in a second plot, the differences between the values in the whole protein and the chain are plotted against the residue position.
}
\examples{
\dontrun{ptm.plot('P04406', property = 'sasa', window = 10, ptm = 'meto')}
\dontrun{ptm.ptm('P04406', property = 'dpx', ptm = c('meto', 'p'))}
}
\seealso{
find.aaindex()
}
\author{
Juan Carlos Aledo
}
