% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_features.R
\name{count_xy}
\alias{count_xy}
\title{Count of points in polygon}
\usage{
count_xy(base, feat, weight = 1)
}
\arguments{
\item{base}{base dataset (eg gridcells), needs to be SpatialPolygonsDataFrame}

\item{feat}{feature dataset (eg another crime generator), needs to be SpatialPointsDataFrame}

\item{weight}{if 1 (default), does not use weights, else pass in string that is the variable name for weights in \code{feat}}
}
\value{
A vector of counts (or weighted sums)
}
\description{
Given a base X/Y dataset, calculates number of feature points that fall inside
}
\details{
This generates a count (or weighted count) of features inside of the base areas. Both should be projected in the same units.
Uses \code{sp::over()} methods in the function.
}
\examples{
data(nyc_liq); data(nyc_bor)
gr_nyc <- prep_grid(nyc_bor,5000)
gr_nyc$liq_cnt <- count_xy(gr_nyc,nyc_liq)
\donttest{
gr_nyc$table_cnt <- count_xy(gr_nyc,nyc_cafe,'SWC_TABLES')
head(gr_nyc@data)
sp::spplot(gr_nyc,zcol='liq_cnt')
}

}
\references{
Wheeler, A. P. (2019). Quantifying the local and spatial effects of alcohol outlets on crime. \emph{Crime & Delinquency}, 65(6), 845-871.
}
\seealso{
\code{\link[=dist_xy]{dist_xy()}} for calculating distance to nearest

\code{\link[=dcount_xy]{dcount_xy()}} for counting points within distance of base polygon

\code{\link[=kern_xy]{kern_xy()}} for estimating gaussian density of points for features at base polygon xy coords

\code{\link[=bisq_xy]{bisq_xy()}} to estimate bi-square kernel weights of points for features at base polygon xy coords

\code{\link[=idw_xy]{idw_xy()}} to estimate inverse distance weights of points for features at base polygon xy coords
}
