% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_features.R
\name{dist_xy}
\alias{dist_xy}
\title{Distance to nearest based on centroid}
\usage{
dist_xy(base, feat, bxy = c("x", "y"), fxy = c("x", "y"))
}
\arguments{
\item{base}{base dataset (eg gridcells)}

\item{feat}{feature dataset (eg another crime generator)}

\item{bxy}{vector of strings that define what the base xy fields are defined as, defaults \code{c('x','y')}}

\item{fxy}{vector of strings that define what the base xy fields are defined as, defaults \code{c('x','y')}}
}
\value{
A vector of distances from base dataset xy to the nearest feature xy
}
\description{
Given a base X/Y dataset, calculates distance to nearest for another feature X/Y dataset
}
\details{
This generates a distance to nearest, based on the provided x/y coordinates (so if using polygons pass the centroid).
This uses kd-trees from RANN, so should be reasonably fast. But I do no projection checking, that is on you. You should not
use this with spherical coordinates. Useful for feature engineering for crime generators.
}
\examples{
data(nyc_bor); data(nyc_cafe)
gr_nyc <- prep_grid(nyc_bor,5000,clip_level=0.3)
gr_nyc$dist_cafe <- dist_xy(gr_nyc,nyc_cafe)
head(gr_nyc@data)
\donttest{
sp::spplot(gr_nyc,zcol='dist_cafe')
}

}
\references{
Caplan, J. M., Kennedy, L. W., & Miller, J. (2011). Risk terrain modeling: Brokering criminological theory and GIS methods for crime forecasting. \emph{Justice Quarterly}, 28(2), 360-381.

Wheeler, A. P., & Steenbeek, W. (2021). Mapping the risk terrain for crime using machine learning. \emph{Journal of Quantitative Criminology}, 37(2), 445-480.
}
\seealso{
\code{\link[=count_xy]{count_xy()}} for counting points inside of base polygon

\code{\link[=dcount_xy]{dcount_xy()}} for counting points within distance of base polygon

\code{\link[=kern_xy]{kern_xy()}} for estimating gaussian density of points for features at base polygon xy coords

\code{\link[=bisq_xy]{bisq_xy()}} for estimate bi-square kernel of points for features at base polygon xy coords

\code{\link[=idw_xy]{idw_xy()}} for estimate inverese distance weighted of points for features at base polygon xy coords
}
