% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stem_modified_hunspell.R
\name{stem_modified_hunspell}
\alias{stem_modified_hunspell}
\title{Stemming with small modification of Hunspell}
\usage{
stem_modified_hunspell(words, complete = TRUE)
}
\arguments{
\item{words}{character vector of words to be stemmed}

\item{complete}{wheter words must be completed or not (T)}
}
\description{
This function uses Hunspell Stemmer to stem a vector of words.
It uses the (Portuguese Brazilian) dictionary by default, and unlike
hunspell::hunspell_stem it returns only one stem per word.
}
\details{
Then it uses the rslp stemmer in the hunspell stemmed result.

As hunspell_stem can return a list of stems for each word, the function
takes the stems that appears the most in the vector for each word.
}
\examples{
words <- c("balões", "aviões", "avião", "gostou", "gosto", "gostaram")
ptstem:::stem_modified_hunspell(words)

}
