% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{route_information}
\alias{route_information}
\title{Information for a given route}
\usage{
route_information(
  route_id,
  include_geopath = FALSE,
  geopath_utc = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{route_id}{Integer. These can be listed and described with the
\code{\link{routes}} function.}

\item{include_geopath}{Logical. Whether to populate the \code{geopath} column.
Defaults to FALSE.}

\item{geopath_utc}{Date, or character that can be converted to a date. The
UTC date for which the geopaths are effective. Defaults to the current
date. Has no effect if \code{include_geopath = FALSE}. It's uncertain how much
historical or future-dated data is available.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble of routes, with the following columns:
\itemize{
\item \code{route_id}
\item \code{route_gtfs_id}
\item \code{route_name}
\item \code{route_type}
\item \code{route_type_description}
\item \code{route_number}
\item \code{geopath}
\item \code{service_status}
\item \code{service_status_timestamp}
}
}
\description{
Information for a given route
}
\examples{
\dontrun{
route_information(6)
route_information(6, include_geopath = TRUE)
route_information(6, include_geopath = TRUE, geopath_utc = "2020-07-01")
}

}
