% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_functions.R
\name{bst}
\alias{bst}
\title{Bootstrap Confidence Intervals.}
\usage{
bst(x, stat = "mean", n = 1000, CI = 95)
}
\arguments{
\item{x}{A numerical variable. Missing observations are removed by default.}

\item{stat}{Statistic, either "mean" (default), "median" or "gmean" (geometric mean).}

\item{n}{Number of replicates for the bootstrap (n=1000 by default).}

\item{CI}{Confidence intervals (CI=95 by default).}
}
\value{
A data frame with the estimate and confidence intervals.
}
\description{
\code{bst} estimates confidence intervals around the \link{mean}, \link{median} or \link{geo_mean}.
}
\examples{
data(IgM, package="ISwR")
bst(IgM, "median")

bst(IgM, "gmean")
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.
}
