% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_functions.R
\name{cross_tab}
\alias{cross_tab}
\title{Cross-tabulation of categorical variables.}
\usage{
cross_tab(object = NULL, formula = NULL, data = NULL, percent = "col")
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: ~ x or ~ x|z (for groups).}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{percent}{Character used to select column percentages (\code{"col"}, default) or row percentages (\code{"row"}).}
}
\value{
A table of class \code{etable}.
}
\description{
\code{cross_tab} uses formulas to construct relatively simple pivot tables using functions from the \code{expss} package.
}
\examples{
data(Oncho, package = 'pubh')
Oncho <- Oncho \%>\%
  apply_labels(
    mf = 'Infection',
    area = 'Residence',
    agegrp = 'Age group (years)',
    sex = 'Sex',
    mfload = 'Load',
    lesions = 'Number of lesions'
 )

Oncho \%>\%
  cross_tab(mf ~ area)

cross_tab(mf ~ sex|area, data = Oncho)

require(dplyr)
Oncho \%>\%
  filter(sex == "Female") \%>\%
  cross_tab(mf ~ agegrp)
}
