% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_apa.R
\name{style.apa.numeric}
\alias{style.apa.numeric}
\title{Formats a numeric vector}
\usage{
style.apa.numeric(x, name, inbracket, nsmall = pp_opts$get("nsmall"),
  replace0 = FALSE, leading0 = TRUE, ...)
}
\arguments{
\item{x}{a list. First list item has to be a numeric vector. All other
items are ignored.}

\item{name}{a character. Giving the identifier name of the numeric (like in
\code{x = 12}).}

\item{inbracket}{a character. Giving additional information after the
identifier, like a degree of freedom (e.g. \code{t(12) = 3.42}).}

\item{nsmall}{a integer. The minimum number of digits to the right of the
decimal point in formatting real/complex numbers in non-scientific formats.}

\item{replace0}{a boolean. Controls whether numbers that are absolute
smaller than \code{1/(10^nsmall)} are replaced with this term.  For example
\eqn{p = .0001} with \eqn{p < .001}. Pay attention that zero is replaced as
well.}

\item{leading0}{a boolean, specifying whether a zero before the decimal
point is printed.}

\item{...}{further arguments passed to \code{\link{format}}.}
}
\value{
numeric vector.
}
\description{
This style functions takes a numeric vector in a list and returns a
formatted numeric vector. Additional arguments can be given specifying how
to format the numeric vector.
}
\details{
Please note that this is a internal style function. It is called
from \code{\link{pprint}} and not exported to user namespace. Usually
\code{\link{pprint}} determines the correct style function automatically,
but you can define the style function by using the \code{format} argument
of \code{\link{pprint}} (pass the name of this function without
\code{style.apa.} prefix). Additionally you can pass the arguments listed
in this documentation to \code{\link{pprint}}.

Argument \code{x} of this function expects a list. Be aware that you do not
have to pass a list to \code{\link{pprint}} or \code{\link{pull.pubprint}}
-- these functions will convert your arguments. This is only necessary if
you want to pass additionally information to the internal style functions
(see vignette for examples).
}
\examples{
pprint(c(.74895, 13.1234567), format = "numeric")
}
\seealso{
Other APA.style.functions: \code{\link{style.apa.anova}},
  \code{\link{style.apa.bartlett}},
  \code{\link{style.apa.character}},
  \code{\link{style.apa.chisq}},
  \code{\link{style.apa.cor.test}},
  \code{\link{style.apa.df}},
  \code{\link{style.apa.fisher}},
  \code{\link{style.apa.ks}},
  \code{\link{style.apa.p.value}},
  \code{\link{style.apa.shapiro}},
  \code{\link{style.apa.summary.aovlist}},
  \code{\link{style.apa.summary.lm.beta.coeff}},
  \code{\link{style.apa.summary.lm.coeff}},
  \code{\link{style.apa.summary.lm.equation}},
  \code{\link{style.apa.summary.lm.model}},
  \code{\link{style.apa.t.test}}
}

