% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/puls.R
\name{PULS}
\alias{PULS}
\title{Partitioning Using Local Subregions (PULS)}
\usage{
PULS(
  toclust.fd,
  method = c("pam", "ward"),
  intervals = c(0, 1),
  spliton = NULL,
  distmethod = c("usc", "manual"),
  labels = toclust.fd$fdnames[2]$reps,
  nclusters = length(toclust.fd$fdnames[2]$reps),
  minbucket = 2,
  minsplit = 4
)
}
\arguments{
\item{toclust.fd}{A functional data object (i.e., having class \code{fd}) created
from \code{fda} package. See \code{\link[fda:fd]{fda::fd()}}.}

\item{method}{The clustering method you want to run in each subregion. Can be
chosen between \code{pam} and \code{ward}.}

\item{intervals}{A data set (or matrix) with rows are intervals and columns
are the beginning and ending indexes of of the interval.}

\item{spliton}{Restrict the partitioning on a specific set of subregions.}

\item{distmethod}{The method for calculating the distance matrix. Choose
between \code{"usc"} and \code{"manual"}. \code{"usc"} uses \code{\link[fda.usc:metric.lp]{fda.usc::metric.lp()}}
function while \code{"manual"} uses squared distance between functions. See
Details.}

\item{labels}{The name of entities.}

\item{nclusters}{The number of clusters.}

\item{minbucket}{The minimum number of data points in one cluster allowed.}

\item{minsplit}{The minimum size of a cluster that can still be considered to
be a split candidate.}
}
\value{
A \code{PULS} object. See \link{PULS.object} for details.
}
\description{
PULS function for functional data (only used when you know that the data
shouldn't be converted into functional because it's already smooth, e.g.
your data are step function)
}
\details{
If choosing \code{distmethod = "manual"}, the L2 distance between all pairs of
functions \eqn{y_i(t)} and \eqn{y_j(t)} is given by:
\deqn{d_R(y_i, y_j) = \sqrt{\int_{a_r}^{b_r} [y_i(t) - y_j(t)]^2 dt}.}
}
\examples{
\donttest{
library(fda)

# Build a simple fd object from already smoothed smoothed_arctic
data(smoothed_arctic)
NBASIS <- 300
NORDER <- 4
y <- t(as.matrix(smoothed_arctic[, -1]))
splinebasis <- create.bspline.basis(rangeval = c(1, 365),
                                    nbasis = NBASIS,
                                    norder = NORDER)
fdParobj <- fdPar(fdobj = splinebasis,
                  Lfdobj = 2,
                  # No need for any more smoothing
                  lambda = .000001)
yfd <- smooth.basis(argvals = 1:365, y = y, fdParobj = fdParobj)

Jan <- c(1, 31); Feb <- c(31, 59); Mar <- c(59, 90)
Apr <- c(90, 120); May <- c(120, 151); Jun <- c(151, 181)
Jul <- c(181, 212); Aug <- c(212, 243); Sep <- c(243, 273)
Oct <- c(273, 304); Nov <- c(304, 334); Dec <- c(334, 365)

intervals <-
  rbind(Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec)

PULS4_pam <- PULS(toclust.fd = yfd$fd, intervals = intervals,
                  nclusters = 4, method = "pam")
PULS4_pam
}
}
\seealso{
\code{\link[fda:is.fd]{fda::is.fd()}}
}
